/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ShortCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.ByteKeyShortMap;
import bak.pcj.map.ByteKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteKeyShortMap
implements ByteKeyShortMap {
    protected AbstractByteKeyShortMap() {
    }

    public void clear() {
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public short remove(byte key) {
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            short value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultShort();
    }

    public void putAll(ByteKeyShortMap map) {
        ByteKeyShortMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(byte key) {
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public short get(byte key) {
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultShort();
    }

    public boolean containsValue(short value) {
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteKeyShortMap)) {
            return false;
        }
        ByteKeyShortMap map = (ByteKeyShortMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            byte k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultByteHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultShortHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short tget(byte key) {
        short value = this.get(key);
        if (value == MapDefaults.defaultShort() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ByteKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ShortCollection values();

    public abstract short put(byte var1, short var2);

    public abstract short lget();

    public abstract ByteSet keySet();

    public abstract ByteKeyShortMapIterator entries();
}

