/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanIterator;
import bak.pcj.adapter.IteratorToBooleanIteratorAdapter;
import bak.pcj.set.AbstractBooleanSet;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToBooleanSetAdapter
extends AbstractBooleanSet
implements BooleanSet {
    protected Set set;

    public SetToBooleanSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToBooleanSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(boolean v) {
        return this.set.add(new Boolean(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(boolean v) {
        return this.set.contains(new Boolean(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public BooleanIterator iterator() {
        return new IteratorToBooleanIteratorAdapter(this.set.iterator());
    }

    public boolean remove(boolean v) {
        return this.set.remove(new Boolean(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isBooleanAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

