/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortCollection;
import bak.pcj.adapter.CollectionToShortCollectionAdapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyShortMap;
import bak.pcj.map.CharKeyShortMap;
import bak.pcj.map.CharKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyShortMapAdapter
extends AbstractCharKeyShortMap
implements CharKeyShortMap {
    protected Map map;
    protected Short lastValue;

    public MapToCharKeyShortMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToCharKeyShortMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        this.lastValue = (Short)this.map.get(new Character(key));
        return this.lastValue != null;
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(new Short(value));
    }

    public CharKeyShortMapIterator entries() {
        return new CharKeyShortMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyShortMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public short getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public short get(char key) {
        Short value = (Short)this.map.get(new Character(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public short lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public short put(char key, short value) {
        Short oldValue = this.map.put(new Character(key), new Short(value));
        return oldValue == null ? MapDefaults.defaultShort() : oldValue;
    }

    public short remove(char key) {
        Short value = (Short)this.map.remove(new Character(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ShortCollection values() {
        return new CollectionToShortCollectionAdapter(this.map.values());
    }

    public short tget(char key) {
        Short value = (Short)this.map.get(new Character(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isCharKeyShortAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

