/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.IntSetToSetAdapter;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.IntKeyMap;
import bak.pcj.map.IntKeyMapIterator;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IntKeyMapToMapAdapter
implements Map {
    protected IntKeyMap map;

    public IntKeyMapToMapAdapter(IntKeyMap map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey((Integer)key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getKey() == null) {
                return false;
            }
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        int k = (Integer)key;
        return this.map.get(k);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return new IntSetToSetAdapter(this.map.keySet());
    }

    public Object put(Object key, Object value) {
        int k = (Integer)key;
        return this.map.put(k, value);
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        if (!(key instanceof Integer)) {
            return null;
        }
        int k = (Integer)key;
        return this.map.remove(k);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    class Entry
    implements Map.Entry {
        Integer key;
        Object value;

        Entry(int key, Object value) {
            this.key = new Integer(key);
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return IntKeyMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return DefaultIntHashFunction.INSTANCE.hash(this.key) ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                IntKeyMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            IntKeyMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return IntKeyMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ IntKeyMapToMapAdapter access$000(EntrySet x0) {
            return x0.IntKeyMapToMapAdapter.this;
        }
    }
}

