/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;

    public static Version parseVersionNumber(String number) throws Exception {
        int dashIdx = ((String)number).indexOf("-");
        if (dashIdx != -1) {
            number = ((String)number).substring(0, ((String)number).indexOf("-"));
        }
        switch (Version.numDots((String)number)) {
            case 0: {
                number = (String)number + ".0.0";
                break;
            }
            case 1: {
                number = (String)number + ".0";
                break;
            }
        }
        String[] parts = ((String)number).split("\\.");
        String major = parts[0];
        String minor = parts.length > 1 ? parts[1] : "0";
        String micro = parts.length > 2 ? parts[2] : "0";
        return new Version(major, minor, micro);
    }

    public Version(String major, String minor, String micro) {
        this.major = Integer.parseInt(major);
        this.minor = Integer.parseInt(minor);
        this.micro = Integer.parseInt(micro);
    }

    public Version() {
        this("0", "0", "0");
    }

    @Override
    public int compareTo(Version o) {
        if (this.major != o.major) {
            return Integer.compare(this.major, o.major);
        }
        if (this.minor != o.minor) {
            return Integer.compare(this.minor, o.minor);
        }
        if (this.micro != o.micro) {
            return Integer.compare(this.micro, o.micro);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.micro != version.micro) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }

    private static int numDots(String number) {
        int num = 0;
        for (int i = 0; i < number.length(); ++i) {
            if (number.charAt(i) != '.') continue;
            ++num;
        }
        return num;
    }
}

