/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http.commons;

import java.util.Collections;
import java.util.List;
import org.geotools.http.AbstractHTTPClientFactory;
import org.geotools.http.HTTPBehavior;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.http.LoggingHTTPClient;
import org.geotools.http.commons.MultithreadedHttpClient;

public class MultithreadedHttpClientFactory
extends AbstractHTTPClientFactory {
    public List<Class<?>> clientClasses() {
        return Collections.singletonList(MultithreadedHttpClient.class);
    }

    public final HTTPClient createClient(List<Class<? extends HTTPBehavior>> behaviors) {
        return new MultithreadedHttpClient();
    }

    protected HTTPClient createLogging(HTTPClient client) {
        return new LoggingConnectionPoolingHTTPClient(client);
    }

    static class LoggingConnectionPoolingHTTPClient
    extends LoggingHTTPClient
    implements HTTPConnectionPooling {
        public LoggingConnectionPoolingHTTPClient(HTTPClient delegate) {
            super(delegate);
        }

        public LoggingConnectionPoolingHTTPClient(HTTPClient delegate, String charset) {
            super(delegate, charset);
        }

        public int getMaxConnections() {
            return ((HTTPConnectionPooling)this.delegate).getMaxConnections();
        }

        public void setMaxConnections(int maxConnections) {
            ((HTTPConnectionPooling)this.delegate).setMaxConnections(maxConnections);
        }

        public void close() {
        }
    }
}

