/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GeoNetworkHttpSessionRequestCache
extends HttpSessionRequestCache {
    static final String SAVED_REQUEST = "SPRING_SECURITY_SAVED_REQUEST";
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;
    private RequestMatcher allowedUrlsMatcher;

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.allowedUrlsMatcher.matches(request)) {
            DefaultSavedRequest savedRequest = new DefaultSavedRequest(request, this.portResolver);
            if (this.createSessionAllowed || request.getSession(false) != null) {
                request.getSession().setAttribute(SAVED_REQUEST, (Object)savedRequest);
            }
        }
    }

    public void setAllowedUrlsPatterns(Set<String> allowedUrlsPatterns) {
        this.allowedUrlsMatcher = new RegexRequestMatcher(String.join((CharSequence)"|", allowedUrlsPatterns), null);
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }
}

