/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.setting.SettingManager;

public class ProxyConfiguration {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USERNAME = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_USERNAME = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private boolean enabled = false;
    private boolean isProxyConfiguredInSystemProperties = false;
    private String host;
    private String port;
    private String username;
    private String password;
    private String ignoreHostList;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isProxyConfiguredInSystemProperties() {
        return this.isProxyConfiguredInSystemProperties;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIgnoreHostList() {
        return this.ignoreHostList;
    }

    public ProxyConfiguration(boolean isProxyConfiguredInSystemProperties) {
        this.isProxyConfiguredInSystemProperties = isProxyConfiguredInSystemProperties;
        if (this.isProxyConfiguredInSystemProperties) {
            this.enabled = true;
        }
    }

    public void refresh(SettingManager settingManager) {
        boolean bl = this.enabled = this.isProxyConfiguredInSystemProperties || settingManager.getValueAsBool("system/proxy/use", false);
        if (this.enabled) {
            if (this.isProxyConfiguredInSystemProperties) {
                if (StringUtils.isNotBlank((String)System.getProperty(HTTPS_PROXY_HOST))) {
                    this.host = System.getProperty(HTTPS_PROXY_HOST);
                    this.port = System.getProperty(HTTPS_PROXY_PORT);
                    this.username = System.getProperty(HTTPS_PROXY_USERNAME, "");
                    this.password = System.getProperty(HTTPS_PROXY_PASSWORD, "");
                } else {
                    this.host = System.getProperty(HTTP_PROXY_HOST);
                    this.port = System.getProperty(HTTP_PROXY_PORT);
                    this.username = System.getProperty(HTTP_PROXY_USERNAME, "");
                    this.password = System.getProperty(HTTP_PROXY_PASSWORD, "");
                }
                this.ignoreHostList = System.getProperty(HTTP_NON_PROXY_HOSTS, "").replace("\\.", "\\\\.").replace("\\*", "\\.\\*");
            } else {
                this.host = settingManager.getValue("system/proxy/host");
                this.port = settingManager.getValue("system/proxy/port");
                this.username = settingManager.getValue("system/proxy/username");
                this.password = settingManager.getValue("system/proxy/password");
                this.ignoreHostList = settingManager.getValue("system/proxy/ignorehostlist");
            }
        }
    }
}

