/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.oidclogout;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionInformation;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionRegistry;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfToken;

public final class OidcSessionRegistryAuthenticationStrategy
implements SessionAuthenticationStrategy {
    @Autowired
    private OidcSessionRegistry oidcSessionRegistry;

    private OidcSessionRegistryAuthenticationStrategy() {
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        Object auth;
        HttpSession session = request.getSession(false);
        if (session != null && (auth = authentication.getPrincipal()) instanceof OidcUser) {
            OidcUser user = (OidcUser)auth;
            String sessionId = session.getId();
            final CsrfToken csrfToken = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
            HashMap<String, String> headers = csrfToken != null ? new HashMap<String, String>(){
                {
                    this.put(csrfToken.getHeaderName(), csrfToken.getToken());
                }
            } : Collections.emptyMap();
            OidcSessionInformation registration = new OidcSessionInformation(sessionId, (Map<String, String>)headers, user);
            Log.debug((String)"geonetwork.security", (Object)String.format("Linking a provider [%s] session to this client's session", user.getIssuer()));
            this.oidcSessionRegistry.saveSessionInformation(registration);
        }
    }
}

