/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.Map;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.utils.Log;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class LoggingOidcAuthorizationCodeAuthenticationProvider
extends OidcAuthorizationCodeAuthenticationProvider {
    OIDCConfiguration oidcConfiguration;

    public LoggingOidcAuthorizationCodeAuthenticationProvider(OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, OAuth2UserService<OidcUserRequest, OidcUser> userService, OIDCConfiguration oidcConfiguration) {
        super(accessTokenResponseClient, userService);
        this.oidcConfiguration = oidcConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication result = super.authenticate(authentication);
        if (this.oidcConfiguration.isLogSensitiveInformation() && authentication instanceof OAuth2LoginAuthenticationToken) {
            this.log((OAuth2LoginAuthenticationToken)result);
        }
        return result;
    }

    void log(OAuth2LoginAuthenticationToken authentication) {
        Log.debug((String)"geonetwork.security", (Object)"OIDC LOGIN");
        Log.debug((String)"geonetwork.security", (Object)"----------");
        Log.debug((String)"geonetwork.security", (Object)this.oidcConfiguration);
        OAuth2AuthorizationResponse authorizationResponse = authentication.getAuthorizationExchange().getAuthorizationResponse();
        if (authorizationResponse != null) {
            Log.debug((String)"geonetwork.security", (Object)("CODE FROM OIDC: " + authorizationResponse.getCode()));
        }
        if (authentication.getAccessToken() != null) {
            Log.debug((String)"geonetwork.security", (Object)("ACCESS TOKEN: " + this.saferJWT(authentication.getAccessToken())));
        }
        if (authentication.getPrincipal() != null && authentication.getPrincipal() instanceof DefaultOidcUser) {
            DefaultOidcUser principal = (DefaultOidcUser)authentication.getPrincipal();
            Log.debug((String)"geonetwork.security", (Object)("ID TOKEN: " + this.saferJWT(principal.getIdToken())));
            if (principal.getAuthorities() != null) {
                Log.debug((String)"geonetwork.security", (Object)"Authorities:");
                for (GrantedAuthority authority : principal.getAuthorities()) {
                    Log.debug((String)"geonetwork.security", (Object)("   + " + authority.getAuthority()));
                }
            }
            this.log(principal.getUserInfo());
        }
    }

    private void log(OidcUserInfo userInfo) {
        if (userInfo == null || userInfo.getClaims() == null) {
            return;
        }
        Log.debug((String)"geonetwork.security", (Object)"USER INFO CLAIMS:");
        for (Map.Entry claim : userInfo.getClaims().entrySet()) {
            Log.debug((String)"geonetwork.security", (Object)("   + " + (String)claim.getKey() + "=" + claim.getValue().toString()));
        }
    }

    public String saferJWT(OidcIdToken jwt) {
        if (jwt != null && jwt.getTokenValue() != null) {
            return this.saferJWT(jwt.getTokenValue());
        }
        return "UNKNOWN";
    }

    public String saferJWT(OAuth2AccessToken jwt) {
        if (jwt != null && jwt.getTokenValue() != null) {
            return this.saferJWT(jwt.getTokenValue());
        }
        return "UNKNOWN";
    }

    public String saferJWT(String jwt) {
        String[] JWTParts = jwt.split("\\.");
        if (JWTParts.length > 1) {
            return JWTParts[1];
        }
        return "NOT A JWT";
    }
}

