/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jeeves.component.ProfileManager;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.ldap.AbstractLDAPUserDetailsContextMapper;
import org.fao.geonet.kernel.security.ldap.LDAPRole;
import org.fao.geonet.kernel.security.ldap.LDAPRoleConverter;
import org.fao.geonet.utils.Log;
import org.springframework.util.StringUtils;

public class LDAPUserDetailsContextMapperWithProfileSearchEnhanced
extends AbstractLDAPUserDetailsContextMapper {
    private String ldapMembershipQuery;
    private String membershipSearchStartObject;
    private List<LDAPRoleConverter> ldapRoleConverters;

    public void setLdapRoleConverters(List<LDAPRoleConverter> vals) {
        this.ldapRoleConverters = vals;
    }

    public void setMembershipSearchStartObject(String membershipSearchStartObject) {
        this.membershipSearchStartObject = membershipSearchStartObject;
    }

    public void setLdapMembershipQuery(String ldapMembershipQuery) {
        this.ldapMembershipQuery = ldapMembershipQuery;
    }

    public String cn_short(Attributes atts) throws NamingException {
        Attribute value = atts.get("cn");
        ArrayList<?> values = Collections.list(value.getAll());
        Comparator comparator = (str1, str2) -> str1.length() > str2.length() ? 1 : -1;
        String shortest = (String)values.stream().sorted(comparator).findFirst().get();
        return shortest;
    }

    public String cn_short(Map<String, ArrayList<String>> userInfo) {
        ArrayList<String> cn = userInfo.get("cn");
        if (cn == null || cn.size() == 0) {
            return null;
        }
        Comparator comparator = (str1, str2) -> str1.length() > str2.length() ? 1 : -1;
        String shortest = (String)cn.stream().sorted(comparator).findFirst().get();
        return shortest;
    }

    public String cn_long(Map<String, ArrayList<String>> userInfo) {
        ArrayList<String> cn = userInfo.get("cn");
        if (cn == null || cn.size() == 0) {
            return null;
        }
        for (String dn : userInfo.get("dn")) {
            dn = dn.replaceFirst("^cn=", "");
            cn.add(dn);
        }
        Comparator comparator = (str1, str2) -> str1.length() > str2.length() ? -1 : 1;
        String longest = (String)cn.stream().sorted(comparator).findFirst().get();
        return longest;
    }

    public String escape(String str) {
        return str.replace("\\", "\\\\");
    }

    public Profile getProfile(String pname) {
        if (this.profileMapping != null && this.profileMapping.containsKey(pname)) {
            return (Profile)this.profileMapping.get(pname);
        }
        Profile p = Profile.findProfileIgnoreCase((String)pname);
        return p;
    }

    @Override
    protected void setProfilesAndPrivileges(Profile defaultProfile, String defaultGroup, Map<String, ArrayList<String>> userInfo, LDAPUser userDetails) {
        if (!StringUtils.isEmpty((Object)this.ldapMembershipQuery)) {
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                StringBuffer sb = new StringBuffer("Group and profile search:");
                sb.append("\nLDAP Membership Query query: \t" + this.ldapMembershipQuery);
                sb.append("\nmembershipSearchStartObject: \t" + this.membershipSearchStartObject);
                Log.debug((String)"geonetwork.ldap", (Object)sb.toString());
            }
            try {
                DirContext dc = this.contextSource.getReadOnlyContext();
                String username = this.escape(userDetails.getUsername());
                String cn_short = this.escape(this.cn_short(userInfo));
                String cn_long = this.escape(this.cn_long(userInfo));
                String groupsQuery = MessageFormat.format(this.ldapMembershipQuery, username, cn_short, cn_long);
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> ldapInfoList = dc.search(this.membershipSearchStartObject, groupsQuery, searchControls);
                HashSet<LDAPRole> allRoles = new HashSet<LDAPRole>();
                try {
                    while (ldapInfoList.hasMore()) {
                        SearchResult sr = ldapInfoList.next();
                        String ldapGroupName = this.cn_short(sr.getAttributes());
                        for (LDAPRoleConverter converter : this.ldapRoleConverters) {
                            List<LDAPRole> newRoles = converter.convert(userInfo, userDetails, ldapGroupName, sr.getAttributes());
                            if (newRoles == null) continue;
                            allRoles.addAll(newRoles);
                        }
                    }
                }
                catch (PartialResultException sr) {
                    // empty catch block
                }
                for (LDAPRole role : allRoles) {
                    userDetails.addPrivilege(role.getGroupName(), role.getProfile());
                }
                Profile highestUserProfile = ProfileManager.getHighestProfile(userDetails.getPrivileges().values().toArray(new Profile[0]));
                if (highestUserProfile != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  Highest user profile is " + highestUserProfile));
                    }
                    userDetails.getUser().setProfile(highestUserProfile);
                }
                if (userDetails.getUser().getProfile() == null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  No profile defined in LDAP, using default profile " + defaultProfile));
                    }
                    userDetails.getUser().setProfile(defaultProfile);
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.ldap", (String)("Failed to extract profiles and groups. Error is: " + e.getMessage()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

