/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.jwtheaders;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersConfiguration;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersTrivialUser;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersUserUtil;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersUsernamePasswordAuthenticationToken;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JwtHeadersAuthFilter
extends GenericFilterBean {
    @Autowired
    public JwtHeadersUserUtil jwtHeadersUserUtil;
    JwtHeadersConfiguration jwtHeadersConfiguration;
    String filterId = UUID.randomUUID().toString();

    public JwtHeadersAuthFilter(JwtHeadersConfiguration jwtHeadersConfiguration) {
        this.jwtHeadersConfiguration = jwtHeadersConfiguration;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        User userDetails;
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        JwtConfiguration config = this.jwtHeadersConfiguration.getJwtConfiguration();
        JwtHeadersTrivialUser user = JwtHeadersTrivialUser.create(config, request);
        if (user == null && existingAuth != null && existingAuth instanceof JwtHeadersUsernamePasswordAuthenticationToken && ((JwtHeadersUsernamePasswordAuthenticationToken)existingAuth).authFilterId.equals(this.filterId)) {
            this.logout(request);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (user == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (existingAuth != null && existingAuth.getName().equals(user.getUsername())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (existingAuth != null && !existingAuth.getName().equals(user.getUsername())) {
            this.logout(request);
        }
        if ((userDetails = this.jwtHeadersUserUtil.getUser(user, this.jwtHeadersConfiguration)) != null) {
            JwtHeadersUsernamePasswordAuthenticationToken auth = new JwtHeadersUsernamePasswordAuthenticationToken(this.filterId, userDetails, null, userDetails.getAuthorities());
            auth.setDetails(userDetails);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void logout(HttpServletRequest request) throws ServletException {
        request.logout();
        SecurityContextHolder.getContext().setAuthentication(null);
        request.getSession().invalidate();
    }
}

