/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.Map;
import org.fao.geonet.exceptions.LabelNotFoundException;
import org.fao.geonet.exceptions.TermNotFoundException;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.utils.Log;

public class TermUriTranslator
implements Translator {
    private static final long serialVersionUID = 1L;
    private final transient ThesaurusFinder finder;
    private final String conceptSchemeUri;
    private final String langCode;
    private transient Thesaurus thesaurus = null;
    private boolean firstWarning = true;

    public TermUriTranslator(ThesaurusFinder finder, String langCode, String conceptSchemeUri) {
        this.finder = finder;
        this.langCode = langCode;
        this.conceptSchemeUri = conceptSchemeUri;
        this.setThesaurus();
    }

    private void setThesaurus() {
        this.thesaurus = this.finder.getThesaurusByConceptScheme(this.conceptSchemeUri);
        if (this.thesaurus == null) {
            Log.warning((String)"geonetwork.thesaurus", (Object)("No thesaurus found for concept scheme " + this.conceptSchemeUri + " (lang=" + this.langCode + ")"));
            if (Log.isDebugEnabled((String)"geonetwork.thesaurus") && this.firstWarning) {
                this.firstWarning = false;
                StringBuilder sb = new StringBuilder();
                sb.append("Available thesauri: [");
                for (Map.Entry<String, Thesaurus> entrySet : this.finder.getThesauriMap().entrySet()) {
                    sb.append("{");
                    sb.append(entrySet.getKey()).append(" -> ").append(entrySet.getValue().getConceptSchemes());
                    sb.append("}");
                }
                sb.append("]");
                Log.debug((String)"geonetwork.thesaurus", (Object)sb.toString());
            }
        }
    }

    @Override
    public String translate(String key) {
        String label;
        KeywordBean keyword;
        if (this.thesaurus == null) {
            this.setThesaurus();
        }
        if (this.thesaurus == null) {
            if (Log.isTraceEnabled((String)"geonetwork.thesaurus")) {
                Log.trace((String)"geonetwork.thesaurus", (Object)("Thesaurus not available [uri:" + this.conceptSchemeUri + ", lang:" + this.langCode + ", " + key + "]"));
            }
            return key;
        }
        try {
            keyword = this.thesaurus.getKeyword(key, this.langCode);
        }
        catch (TermNotFoundException e) {
            Log.error((String)"geonetwork.thesaurus", (Object)("Term not found: " + key));
            return key;
        }
        catch (NullPointerException e) {
            Log.error((String)"geonetwork.thesaurus", (Object)("NPE searching term: " + key));
            return key;
        }
        try {
            label = keyword.getPreferredLabel(this.langCode);
        }
        catch (LabelNotFoundException e) {
            return keyword.getUriCode();
        }
        return label;
    }
}

