/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.schema.AttributeEntry;
import org.fao.geonet.kernel.schema.AttributeGroupEntry;
import org.fao.geonet.kernel.schema.ComplexTypeEntry;
import org.fao.geonet.kernel.schema.ElementEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.GroupEntry;
import org.fao.geonet.kernel.schema.Logger;
import org.fao.geonet.kernel.schema.MetadataAttribute;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.MetadataType;
import org.fao.geonet.kernel.schema.SchemaSubstitutions;
import org.fao.geonet.kernel.schema.SimpleTypeEntry;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Resolver;
import org.fao.geonet.utils.ResolverWrapper;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class SchemaLoader {
    private Element elFirst = null;
    private Map<String, String> hmElements = new HashMap<String, String>();
    private Map<String, ComplexTypeEntry> hmTypes = new HashMap<String, ComplexTypeEntry>();
    private Map<String, List<AttributeEntry>> hmAttrGrp = new HashMap<String, List<AttributeEntry>>();
    private Map<String, AttributeGroupEntry> hmAttrGpEn = new HashMap<String, AttributeGroupEntry>();
    private Map<String, String> hmAbsElems = new HashMap<String, String>();
    private Map<String, ArrayList<ElementEntry>> hmSubsGrp = new HashMap<String, ArrayList<ElementEntry>>();
    private Map<String, String> hmSubsLink = new HashMap<String, String>();
    private Map<String, List<String>> hmSubsNames = new HashMap<String, List<String>>();
    private Map<String, AttributeEntry> hmAttribs = new HashMap<String, AttributeEntry>();
    private Map<String, AttributeEntry> hmAllAttrs = new HashMap<String, AttributeEntry>();
    private Map<String, GroupEntry> hmGroups = new HashMap<String, GroupEntry>();
    private SchemaSubstitutions ssOverRides;
    private String targetNS;
    private String targetNSPrefix;
    private Map<String, List<String>> hmElemRestr = new HashMap<String, List<String>>();
    private Map<String, List<String>> hmTypeRestr = new HashMap<String, List<String>>();
    private Map<String, List<String>> hmMemberTypeRestr = new HashMap<String, List<String>>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataSchema load(Path xmlSchemaFile, Path xmlSubstitutionsFile, SchematronRepository schemaRepo, SchematronCriteriaGroupRepository criteriaGroupRepository) throws Exception {
        this.ssOverRides = new SchemaSubstitutions(xmlSubstitutionsFile);
        if (!Files.exists(xmlSchemaFile, new LinkOption[0])) {
            return new MetadataSchema(schemaRepo, criteriaGroupRepository);
        }
        List<ElementInfo> alElementFiles = this.loadFile(xmlSchemaFile, new HashSet<Path>());
        this.parseElements(alElementFiles);
        for (String o : this.hmSubsGrp.keySet()) {
            List elements = this.hmSubsGrp.get(o);
            ArrayList<String> arrayList = new ArrayList<String>();
            this.hmSubsNames.put(o, arrayList);
            for (ElementEntry ee : elements) {
                if (ee.type == null) {
                    ee.type = this.hmAbsElems.get(o);
                    if (ee.type == null) {
                        Logger.log();
                    }
                }
                this.hmElements.put(ee.name, ee.type);
                arrayList.add(ee.name);
            }
        }
        MetadataSchema mds = new MetadataSchema(schemaRepo, criteriaGroupRepository);
        mds.setPrimeNS(this.elFirst.getAttributeValue("targetNamespace"));
        List annotation = this.elFirst.getChildren("annotation", Geonet.Namespaces.XSD);
        if (annotation != null) {
            Iterator<Object> allAppInfo = new ArrayList();
            for (Element currAnnotation : annotation) {
                List currAppInfo = currAnnotation.getChildren("appinfo", Geonet.Namespaces.XSD);
                if (currAppInfo == null) continue;
                allAppInfo.addAll(currAppInfo);
            }
            mds.setRootAppInfoElements((List<Element>)((Object)allAppInfo));
        }
        for (ElementInfo elementInfo : alElementFiles) {
            mds.addNS(elementInfo.targetNSPrefix, elementInfo.targetNS);
        }
        for (String string : this.hmElements.keySet()) {
            Object elemSubsLink;
            List<String> elemSubs;
            String type = this.hmElements.get(string);
            if (type == null) {
                Logger.log();
                type = this.recurseOnSubstitutionLinks(string);
                if (type == null) {
                    Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: Cannot find type for " + string + ": assuming string"));
                    type = "string";
                } else {
                    Logger.log();
                }
            }
            List<String> elemRestr = this.hmElemRestr.get(string);
            List<String> typeRestr = this.hmTypeRestr.get(type);
            if (elemRestr == null) {
                elemRestr = new ArrayList<String>();
            }
            if (typeRestr != null) {
                elemRestr.addAll(typeRestr);
            }
            if ((elemSubs = this.hmSubsNames.get(string)) == null) {
                elemSubs = new ArrayList<String>();
            }
            if ((elemSubsLink = this.hmSubsLink.get(string)) == null) {
                elemSubsLink = "";
            }
            mds.addElement(string, type, elemRestr, elemSubs, (String)elemSubsLink);
        }
        for (AttributeGroupEntry attributeGroupEntry : this.hmAttrGpEn.values()) {
            for (int k = 0; k < attributeGroupEntry.alAttrs.size(); ++k) {
                AttributeEntry attr = attributeGroupEntry.alAttrs.get(k);
                if (attr.name == null) continue;
                this.hmAllAttrs.put(attr.name, attr);
            }
            ArrayList<AttributeEntry> attrs = this.resolveNestedAttributeGroups(attributeGroupEntry);
            this.hmAttrGrp.put(attributeGroupEntry.name, attrs);
        }
        HashMap<String, AttributeEntry> hmAttrChk = new HashMap<String, AttributeEntry>();
        for (AttributeEntry attr : this.hmAllAttrs.values()) {
            AttributeEntry attrPrev = (AttributeEntry)hmAttrChk.get(attr.unqualifiedName);
            if (attrPrev != null) {
                attr.form = "qualified";
                attrPrev.form = "qualified";
                continue;
            }
            hmAttrChk.put(attr.unqualifiedName, attr);
        }
        ArrayList<ComplexTypeEntry> arrayList = new ArrayList<ComplexTypeEntry>(this.hmTypes.values());
        ListIterator<ComplexTypeEntry> i = arrayList.listIterator();
        while (i.hasNext()) {
            ComplexTypeEntry cte = (ComplexTypeEntry)i.next();
            MetadataType mdt = new MetadataType();
            mdt.setOrType(cte.isOrType);
            if (cte.complexContent != null) {
                if (cte.complexContent.base == null) throw new IllegalArgumentException("base not defined for complexContent in " + cte.name);
                cte.alElements = this.resolveInheritance(cte);
                List<AttributeEntry> complexContentAttribs = this.resolveAttributeInheritance(cte);
                for (AttributeEntry ae : complexContentAttribs) {
                    mdt.addAttribute(this.buildMetadataAttrib(ae));
                }
                ComplexTypeEntry baseCTE = this.hmTypes.get(cte.complexContent.base);
                if (baseCTE.isOrType) {
                    cte.isOrType = true;
                    mdt.setOrType(true);
                    Logger.log();
                }
            } else if (cte.simpleContent != null) {
                List<AttributeEntry> simpleContentAttribs = this.resolveAttributeInheritanceFromSimpleContent(cte);
                for (AttributeEntry ae : simpleContentAttribs) {
                    mdt.addAttribute(this.buildMetadataAttrib(ae));
                }
            } else {
                for (int j = 0; j < cte.alAttribs.size(); ++j) {
                    AttributeEntry ae = cte.alAttribs.get(j);
                    mdt.addAttribute(this.buildMetadataAttrib(ae));
                }
                for (int k = 0; k < cte.alAttribGroups.size(); ++k) {
                    String attribGroup = cte.alAttribGroups.get(k);
                    List<AttributeEntry> al = this.hmAttrGrp.get(attribGroup);
                    if (al == null) {
                        throw new IllegalArgumentException("Attribute group not found : " + attribGroup);
                    }
                    for (AttributeEntry ae : al) {
                        mdt.addAttribute(this.buildMetadataAttrib(ae));
                    }
                }
            }
            for (int j = 0; j < cte.alElements.size(); ++j) {
                ElementEntry ee = cte.alElements.get(j);
                if (ee.groupElem || ee.choiceElem || ee.sequenceElem) {
                    ArrayList<ElementEntry> elements;
                    String extension;
                    String baseName = cte.name;
                    if (ee.choiceElem) {
                        extension = "CHOICE_ELEMENT";
                        elements = ee.alContainerElems;
                    } else if (ee.groupElem) {
                        extension = "GROUP_ELEMENT";
                        GroupEntry group = this.hmGroups.get(ee.ref);
                        elements = group.alElements;
                    } else {
                        extension = "SEQUENCE_ELEMENT";
                        elements = ee.alContainerElems;
                    }
                    ee.name = baseName + extension + Integer.valueOf(j);
                    String type = ee.name;
                    ArrayList<ComplexTypeEntry> newCtes = this.createTypeAndResolveNestedContainers(mds, elements, baseName, extension, j);
                    if (newCtes.size() != 0) {
                        for (ComplexTypeEntry newCte : newCtes) {
                            i.add(newCte);
                            i.previous();
                        }
                    }
                    mds.addElement(ee.name, type, new ArrayList<String>(), new ArrayList<String>(), "");
                    mdt.addElementWithType(ee.name, type, ee.min, ee.max);
                    continue;
                }
                if (ee.ref != null) {
                    boolean choiceType = cte.alElements.size() == 1;
                    this.handleRefElement(j, cte.name, choiceType, ee, mdt, mds);
                    continue;
                }
                if (ee.name == null) throw new IllegalArgumentException("Unknown element type at position " + j + " in complexType " + cte.name);
                ComplexTypeEntry newCte = this.handleLocalElement(j, cte.name, ee, mdt, mds);
                if (newCte == null) continue;
                i.add(newCte);
                i.previous();
            }
            mds.addType(cte.name, mdt);
        }
        mds.setCanEdit(true);
        return mds;
    }

    private String recurseOnSubstitutionLinks(String elemName) {
        String elemLinkName = this.hmSubsLink.get(elemName);
        if (elemLinkName != null) {
            String elemLinkType = this.hmElements.get(elemLinkName);
            if (elemLinkType != null) {
                return elemLinkType;
            }
            return this.recurseOnSubstitutionLinks(elemLinkName);
        }
        return null;
    }

    private ComplexTypeEntry handleLocalElement(Integer elementNr, String baseName, ElementEntry ee, MetadataType mdt, MetadataSchema mds) {
        ComplexTypeEntry cteInt = null;
        ArrayList<String> elemRestr = new ArrayList<String>();
        if (ee.type == null) {
            if (ee.complexType != null) {
                cteInt = ee.complexType;
                ee.type = cteInt.name = ee.name + "HSI" + elementNr + this.getUnqualifiedName(baseName);
            } else if (ee.simpleType != null) {
                ee.type = "string";
                if (ee.simpleType.alEnum != null) {
                    elemRestr.addAll(ee.simpleType.alEnum);
                }
            } else {
                Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: Could not find type for " + ee.name + " - assuming string"));
                ee.type = "string";
            }
        }
        mds.addElement(ee.name, ee.type, elemRestr, new ArrayList<String>(), "");
        mdt.addElementWithType(ee.name, ee.type, ee.min, ee.max);
        return cteInt;
    }

    private ArrayList<ElementEntry> getOverRideSubstitutes(String elementName) {
        ArrayList<ElementEntry> subs = this.hmSubsGrp.get(elementName);
        ArrayList<String> ssOs = this.ssOverRides.getSubstitutes(elementName);
        if (ssOs != null && subs != null) {
            ArrayList<ElementEntry> results = new ArrayList<ElementEntry>();
            List<String> validSubs = this.hmSubsNames.get(elementName);
            for (String altSub : ssOs) {
                if (validSubs != null && !validSubs.contains(altSub)) {
                    Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: schema-substitutions.xml specified " + altSub + " for element " + elementName + " but the schema does not define this as a valid substitute"));
                }
                for (ElementEntry ee : subs) {
                    if (!ee.name.equals(altSub)) continue;
                    results.add(ee);
                }
            }
            if (results.size() == 0 && validSubs != null) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: schema-substitutions.xml has wiped out XSD substitution list for " + elementName));
            }
            return results;
        }
        return null;
    }

    private void handleRefElement(Integer elementNr, String baseName, boolean choiceType, ElementEntry ee, MetadataType mdt, MetadataSchema mds) {
        Object type = this.hmElements.get(ee.ref);
        boolean isAbstract = this.hmAbsElems.containsKey(ee.ref);
        boolean doSubs = true;
        ArrayList<ElementEntry> al = this.getOverRideSubstitutes(ee.ref);
        if (al == null) {
            al = this.hmSubsGrp.get(ee.ref);
        } else {
            doSubs = false;
        }
        if (al != null && al.size() > 0 || isAbstract) {
            if (choiceType) {
                int elementsAdded = this.assembleChoiceElements(mdt, al, doSubs);
                if (!isAbstract && doSubs) {
                    mdt.addRefElementWithType(ee.ref, (String)type, ee.min, ee.max);
                    ++elementsAdded;
                }
                mdt.setOrType(elementsAdded > 1);
            } else {
                MetadataType mdtc = new MetadataType();
                Integer elementsAdded = this.assembleChoiceElements(mdtc, al, doSubs);
                if (!isAbstract && doSubs) {
                    mdtc.addRefElementWithType(ee.ref, ee.type, ee.min, ee.max);
                    Integer n = elementsAdded;
                    Integer n2 = elementsAdded = Integer.valueOf(elementsAdded + 1);
                }
                mdtc.setOrType(elementsAdded > 1);
                Object name = type = ee.ref + "CHOICE_ELEMENT" + elementNr;
                mds.addType((String)type, mdtc);
                mds.addElement((String)name, (String)type, new ArrayList<String>(), new ArrayList<String>(), "");
                mdt.addElementWithType((String)name, (String)type, ee.min, ee.max);
            }
        } else if (!isAbstract) {
            mdt.addRefElementWithType(ee.ref, (String)type, ee.min, ee.max);
        } else {
            Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: element " + ee.ref + " from " + baseName + " has fallen through the logic (abstract: " + isAbstract + ") - ignoring"));
        }
    }

    private ArrayList<AttributeEntry> resolveNestedAttributeGroups(AttributeGroupEntry age) {
        ArrayList<AttributeEntry> attrs = new ArrayList<AttributeEntry>();
        if (age.alAttrGrps.size() > 0) {
            for (int i = 0; i < age.alAttrGrps.size(); ++i) {
                AttributeGroupEntry ageInternal = age.alAttrGrps.get(i);
                AttributeGroupEntry ageRef = this.hmAttrGpEn.get(ageInternal.ref);
                if (ageRef == null) {
                    throw new IllegalArgumentException("ERROR: cannot find attributeGroup with ref " + ageInternal.ref);
                }
                attrs.addAll(this.resolveNestedAttributeGroups(ageRef));
            }
        }
        attrs.addAll(age.alAttrs);
        return attrs;
    }

    private ArrayList<ComplexTypeEntry> createTypeAndResolveNestedContainers(MetadataSchema mds, ArrayList<ElementEntry> al, String baseName, String extension, Integer baseNr) {
        ArrayList<ComplexTypeEntry> complexTypes = new ArrayList<ComplexTypeEntry>();
        Integer oldBaseNr = baseNr;
        if (al == null) {
            return complexTypes;
        }
        MetadataType mdt = new MetadataType();
        if (extension.contains("CHOICE_ELEMENT")) {
            mdt.setOrType(true);
        }
        for (int k = 0; k < al.size(); ++k) {
            ArrayList<ComplexTypeEntry> newCtes;
            String newExtension;
            ElementEntry ee = al.get(k);
            Integer n = baseNr;
            Integer n2 = baseNr = Integer.valueOf(baseNr + 1);
            if (ee.choiceElem) {
                newExtension = "CHOICE_ELEMENT";
                newCtes = this.createTypeAndResolveNestedContainers(mds, ee.alContainerElems, baseName, newExtension, baseNr);
                if (newCtes.size() > 0) {
                    complexTypes.addAll(newCtes);
                }
                ee.name = ee.type = baseName + newExtension + baseNr;
                mds.addElement(ee.name, ee.type, new ArrayList<String>(), new ArrayList<String>(), "");
                mdt.addElementWithType(ee.name, ee.type, ee.min, ee.max);
                continue;
            }
            if (ee.groupElem) {
                newExtension = "GROUP_ELEMENT";
                if (ee.ref != null) {
                    GroupEntry group = this.hmGroups.get(ee.ref);
                    ArrayList<ElementEntry> alGroupElements = group.alElements;
                    ArrayList<ComplexTypeEntry> newCtes2 = this.createTypeAndResolveNestedContainers(mds, alGroupElements, baseName, newExtension, baseNr);
                    if (newCtes2.size() > 0) {
                        complexTypes.addAll(newCtes2);
                    }
                    ee.name = ee.type = baseName + newExtension + baseNr;
                    mds.addElement(ee.name, ee.type, new ArrayList<String>(), new ArrayList<String>(), "");
                    mdt.addElementWithType(ee.name, ee.type, ee.min, ee.max);
                    continue;
                }
                Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: group element ref is NULL in " + baseName + extension + baseNr));
                continue;
            }
            if (ee.sequenceElem) {
                newExtension = "SEQUENCE_ELEMENT";
                newCtes = this.createTypeAndResolveNestedContainers(mds, ee.alContainerElems, baseName, newExtension, baseNr);
                if (newCtes.size() > 0) {
                    complexTypes.addAll(newCtes);
                }
                ee.name = ee.type = baseName + newExtension + baseNr;
                mds.addElement(ee.name, ee.type, new ArrayList<String>(), new ArrayList<String>(), "");
                mdt.addElementWithType(ee.name, ee.type, ee.min, ee.max);
                continue;
            }
            if (ee.name != null) {
                ComplexTypeEntry newCte = this.handleLocalElement(k, baseName, ee, mdt, mds);
                if (newCte == null) continue;
                complexTypes.add(newCte);
                continue;
            }
            this.handleRefElement(k, baseName, false, ee, mdt, mds);
        }
        mds.addType(baseName + extension + oldBaseNr, mdt);
        return complexTypes;
    }

    private int assembleChoiceElements(MetadataType mdt, ArrayList<ElementEntry> al, boolean doSubs) {
        int number = 0;
        if (al == null) {
            return number;
        }
        for (ElementEntry ee : al) {
            ArrayList<ElementEntry> elemSubs;
            if (ee.abstrElem) {
                Integer numberRecursed = this.assembleChoiceElements(mdt, this.hmSubsGrp.get(ee.name), doSubs);
                number += numberRecursed.intValue();
                continue;
            }
            ++number;
            mdt.addElementWithType(ee.name, ee.type, ee.min, ee.max);
            if (!doSubs || (elemSubs = this.hmSubsGrp.get(ee.name)) == null) continue;
            for (ElementEntry eeSub : elemSubs) {
                mdt.addElementWithType(eeSub.name, eeSub.type, eeSub.min, eeSub.max);
                ++number;
            }
        }
        return number;
    }

    private List<ElementInfo> loadFile(Path xmlSchemaFile, HashSet<Path> loadedFiles) throws Exception {
        loadedFiles.add(xmlSchemaFile.toAbsolutePath().normalize());
        Path path = xmlSchemaFile.getParent();
        Log.debug((String)"geonetwork.schemamanager", (Object)("Loading schema " + xmlSchemaFile));
        Element elRoot = Xml.loadFile((Path)xmlSchemaFile);
        if (this.elFirst == null) {
            this.elFirst = elRoot;
        }
        String oldtargetNS = this.targetNS;
        String oldtargetNSPrefix = this.targetNSPrefix;
        this.targetNS = elRoot.getAttributeValue("targetNamespace");
        this.targetNSPrefix = null;
        if (this.targetNS != null) {
            for (Object o : elRoot.getAdditionalNamespaces()) {
                Namespace ns = (Namespace)o;
                if (!this.targetNS.equals(ns.getURI())) continue;
                this.targetNSPrefix = ns.getPrefix();
                break;
            }
            if ("".equals(this.targetNSPrefix)) {
                this.targetNSPrefix = null;
            }
        }
        if ((xmlSchemaFile.toString().contains("xml.xsd") || xmlSchemaFile.toString().contains("xml-mod.xsd")) && this.targetNS.equals("http://www.w3.org/XML/1998/namespace")) {
            this.targetNSPrefix = "xml";
        }
        List children = elRoot.getChildren();
        ArrayList<ElementInfo> alElementFiles = new ArrayList<ElementInfo>();
        for (Element elChild : children) {
            String name = elChild.getName();
            if (name.equals("annotation")) continue;
            if (name.equals("import") || name.equals("include")) {
                Path scFile;
                String schemaLoc = elChild.getAttributeValue("schemaLocation");
                if (schemaLoc.startsWith("http:")) {
                    Resolver resolver = ResolverWrapper.getInstance();
                    String scPath = resolver.getXmlResolver().resolveURI(schemaLoc);
                    if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                        Log.debug((String)"geonetwork.schemamanager", (Object)("Cats: " + Arrays.toString(resolver.getXmlResolver().getCatalogList()) + " Resolved " + schemaLoc + " " + scPath));
                    }
                    if (scPath == null) {
                        Log.warning((String)"geonetwork.schemamanager", (Object)("Cannot resolve " + schemaLoc + ": will append last component to current path (not sure it will help though!)"));
                        int lastSlash = schemaLoc.lastIndexOf(47);
                        scFile = path.resolve(schemaLoc.substring(lastSlash + 1));
                    } else {
                        scFile = IO.toPath((URI)new URI(scPath));
                    }
                } else {
                    scFile = path.resolve(schemaLoc);
                }
                if (loadedFiles.contains(scFile.toAbsolutePath().normalize())) continue;
                alElementFiles.addAll(this.loadFile(scFile, loadedFiles));
                continue;
            }
            alElementFiles.add(new ElementInfo(elChild, xmlSchemaFile, this.targetNS, this.targetNSPrefix));
        }
        this.targetNS = oldtargetNS;
        this.targetNSPrefix = oldtargetNSPrefix;
        return alElementFiles;
    }

    private void parseElements(List<ElementInfo> alElementFiles) throws JDOMException {
        this.hmElements.clear();
        this.hmTypes.clear();
        this.hmAttrGrp.clear();
        this.hmAbsElems.clear();
        this.hmSubsGrp.clear();
        this.hmSubsLink.clear();
        this.hmElemRestr.clear();
        this.hmTypeRestr.clear();
        this.hmAttribs.clear();
        this.hmAllAttrs.clear();
        this.hmGroups.clear();
        for (ElementInfo ei : alElementFiles) {
            Element elChild = ei.element;
            String name = elChild.getName();
            if (name.equals("element")) {
                this.buildGlobalElement(ei);
                continue;
            }
            if (name.equals("complexType")) {
                this.buildComplexType(ei);
                continue;
            }
            if (name.equals("simpleType")) {
                this.buildSimpleType(ei);
                continue;
            }
            if (name.equals("attribute")) {
                this.buildGlobalAttrib(ei);
                continue;
            }
            if (name.equals("group")) {
                this.buildGlobalGroup(ei);
                continue;
            }
            if (name.equals("attributeGroup")) {
                this.buildGlobalAttributeGroup(ei);
                continue;
            }
            Logger.log();
        }
    }

    private void buildGlobalElement(ElementInfo ei) {
        ElementEntry ee = new ElementEntry(ei);
        if (ee.name == null) {
            throw new IllegalArgumentException("Name is null for element : " + ee.name);
        }
        if (ee.substGroup != null) {
            ArrayList<ElementEntry> al = this.hmSubsGrp.get(ee.substGroup);
            if (al == null) {
                al = new ArrayList();
                this.hmSubsGrp.put(ee.substGroup, al);
            }
            al.add(ee);
            String existingSubstitionGroup = this.hmSubsLink.get(ee.name);
            if (existingSubstitionGroup != null && !ee.substGroup.equals(existingSubstitionGroup)) {
                throw new IllegalArgumentException("Substitution link collision for " + ee.name + " link to " + existingSubstitionGroup + ". Already bound to " + ee.substGroup);
            }
            this.hmSubsLink.put(ee.name, ee.substGroup);
        }
        if (ee.abstrElem) {
            String existingType = this.hmAbsElems.get(ee.name);
            if (existingType != null && !ee.type.equals(existingType)) {
                throw new IllegalArgumentException("Namespace collision for " + ee.name + " type " + existingType + ". Already bound to " + ee.type);
            }
            this.hmAbsElems.put(ee.name, ee.type);
            return;
        }
        if (ee.complexType != null) {
            String type = ee.name + "HSI";
            ee.complexType.name = type;
            ee.type = type;
            if (this.hmElements.containsKey(ee.name)) {
                throw new IllegalArgumentException("Namespace collision for : " + ee.name);
            }
            this.hmElements.put(ee.name, type);
            this.hmTypes.put(type, ee.complexType);
        } else if (ee.simpleType != null) {
            if (this.hmElements.containsKey(ee.name)) {
                throw new IllegalArgumentException("Namespace collision for : " + ee.name);
            }
            ee.type = "string";
            this.hmElements.put(ee.name, ee.type);
            this.hmElemRestr.put(ee.name, ee.simpleType.alEnum);
        } else {
            if (ee.type == null && ee.substGroup == null) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING: " + ee.name + " is a global element without a type - assuming a string"));
                ee.type = "string";
            }
            this.hmElements.put(ee.name, ee.type);
        }
        if (ee.name.contains("SensorML")) {
            Logger.log();
        }
    }

    private void buildComplexType(ElementInfo ei) {
        ComplexTypeEntry ct = new ComplexTypeEntry(ei);
        ComplexTypeEntry existingType = this.hmTypes.get(ct.name);
        if (existingType != null && !ct.name.equals(existingType.name)) {
            throw new IllegalArgumentException("Namespace collision for complex type " + ct.name + " type " + existingType.name + "already defined.");
        }
        this.hmTypes.put(ct.name, ct);
    }

    private void buildSimpleType(ElementInfo ei) {
        SimpleTypeEntry st = new SimpleTypeEntry(ei);
        if (this.hmTypeRestr.containsKey(st.name)) {
            throw new IllegalArgumentException("Namespace collision for : " + st.name);
        }
        this.hmTypeRestr.put(st.name, st.alEnum);
        if (!this.hmMemberTypeRestr.containsKey(st.name)) {
            this.hmMemberTypeRestr.put(st.name, st.alTypes);
        }
    }

    private void buildGlobalAttrib(ElementInfo ei) {
        AttributeEntry at = new AttributeEntry(ei);
        if (this.hmAttribs.containsKey(at.name)) {
            throw new IllegalArgumentException("Namespace collision for : " + at.name);
        }
        this.hmAttribs.put(at.name, at);
        this.hmAllAttrs.put(at.name, at);
    }

    private void buildGlobalGroup(ElementInfo ei) {
        GroupEntry ge = new GroupEntry(ei);
        if (this.hmGroups.containsKey(ge.name)) {
            throw new IllegalArgumentException("Namespace collision for : " + ge.name);
        }
        this.hmGroups.put(ge.name, ge);
    }

    private void buildGlobalAttributeGroup(ElementInfo ei) {
        AttributeGroupEntry age = new AttributeGroupEntry(ei);
        if (this.hmAttrGpEn.containsKey(age.name)) {
            throw new IllegalArgumentException("Namespace collision for : " + age.name);
        }
        this.hmAttrGpEn.put(age.name, age);
    }

    private List<AttributeEntry> resolveAttributeInheritanceFromSimpleContent(ComplexTypeEntry cte) {
        ArrayList<Object> result = new ArrayList();
        if (cte.simpleContent == null) {
            throw new IllegalArgumentException("SimpleContent must be present in base type of the SimpleContent in " + cte.name);
        }
        String baseType = cte.simpleContent.base;
        ComplexTypeEntry baseCTE = this.hmTypes.get(baseType);
        if (baseCTE != null) {
            result = new ArrayList<AttributeEntry>(this.resolveAttributeInheritanceFromSimpleContent(baseCTE));
        }
        if (cte.simpleContent.restriction) {
            List adds = (List)cte.simpleContent.alAttribs.clone();
            for (int i = 0; i < result.size(); ++i) {
                AttributeEntry attrib = (AttributeEntry)result.get(i);
                for (Object add : adds) {
                    AttributeEntry attribOther = (AttributeEntry)add;
                    boolean eqAttrib = this.eqAttribs(attribOther, attrib);
                    if (!eqAttrib) continue;
                    result.set(i, attribOther);
                }
            }
        } else {
            List clone = (List)cte.simpleContent.alAttribs.clone();
            result.addAll(clone);
        }
        if (cte.simpleContent.alAttribGroups != null) {
            for (int k = 0; k < cte.simpleContent.alAttribGroups.size(); ++k) {
                String attribGroup = cte.simpleContent.alAttribGroups.get(k);
                List<AttributeEntry> al = this.hmAttrGrp.get(attribGroup);
                if (al == null) {
                    throw new IllegalArgumentException("Attribute group not found : " + attribGroup);
                }
                for (AttributeEntry anAl : al) {
                    result.add(anAl);
                }
            }
        }
        return result;
    }

    boolean eqAttribs(AttributeEntry attribOther, AttributeEntry attrib) {
        return attribOther.name != null ? (attrib.name != null ? attribOther.name.equals(attrib.name) : attribOther.name.equals(attrib.reference)) : (attrib.name != null ? attribOther.reference.equals(attrib.name) : attribOther.reference.equals(attrib.reference));
    }

    private List<AttributeEntry> resolveAttributeInheritance(ComplexTypeEntry cte) {
        List<AttributeEntry> al;
        if (cte.complexContent == null) {
            return cte.alAttribs;
        }
        String baseType = cte.complexContent.base;
        ComplexTypeEntry baseCTE = this.hmTypes.get(baseType);
        if (baseCTE == null) {
            throw new IllegalArgumentException("Base type not found for : " + baseType);
        }
        ArrayList<AttributeEntry> result = new ArrayList<AttributeEntry>(this.resolveAttributeInheritance(baseCTE));
        if (cte.complexContent.restriction) {
            ArrayList<AttributeEntry> adds = cte.complexContent.alAttribs;
            for (int i = 0; i < result.size(); ++i) {
                AttributeEntry attrib = (AttributeEntry)result.get(i);
                for (AttributeEntry attribOther : adds) {
                    boolean eqAttrib = this.eqAttribs(attribOther, attrib);
                    if (!eqAttrib) continue;
                    result.set(i, attribOther);
                }
            }
        } else {
            result.addAll(cte.complexContent.alAttribs);
            if (cte.complexContent.alAttribGroups != null) {
                for (int k = 0; k < cte.complexContent.alAttribGroups.size(); ++k) {
                    String attribGroup = cte.complexContent.alAttribGroups.get(k);
                    al = this.hmAttrGrp.get(attribGroup);
                    if (al == null) {
                        throw new IllegalArgumentException("Attribute group not found : " + attribGroup);
                    }
                    for (AttributeEntry anAl : al) {
                        result.add(anAl);
                    }
                }
            }
        }
        if (baseCTE.alAttribGroups != null) {
            for (int k = 0; k < baseCTE.alAttribGroups.size(); ++k) {
                String attribGroup = baseCTE.alAttribGroups.get(k);
                al = this.hmAttrGrp.get(attribGroup);
                if (al == null) {
                    throw new IllegalArgumentException("Attribute group not found : " + attribGroup);
                }
                for (AttributeEntry anAl : al) {
                    result.add(anAl);
                }
            }
        }
        return result;
    }

    private List<ElementEntry> resolveInheritance(ComplexTypeEntry cte) {
        ComplexTypeEntry baseCTE;
        if ((cte == null || cte.complexContent == null) && cte != null) {
            return cte.alElements;
        }
        String baseType = null;
        if (cte != null) {
            baseType = cte.complexContent.base;
        }
        if ((baseCTE = this.hmTypes.get(baseType)) == null) {
            throw new IllegalArgumentException("Base type not found for : " + baseType);
        }
        ArrayList<ElementEntry> result = new ArrayList<ElementEntry>();
        if (!cte.complexContent.restriction) {
            result = new ArrayList<ElementEntry>(this.resolveInheritance(baseCTE));
        }
        result.addAll(cte.complexContent.alElements);
        return result;
    }

    private MetadataAttribute buildMetadataAttrib(AttributeEntry ae) {
        String name = ae.name;
        String ref = ae.reference;
        String value = ae.defValue;
        boolean overRequired = ae.required;
        MetadataAttribute ma = new MetadataAttribute();
        if (ref != null && (ae = this.hmAttribs.get(ref)) == null) {
            throw new IllegalArgumentException("Reference '" + ref + "' not found for attrib : " + name + ":" + ref);
        }
        ma.name = ref != null && ref.contains(":") ? ref : ae.unqualifiedName;
        ma.defValue = value != null ? value : ae.defValue;
        ma.required = overRequired;
        if (ae.type != null) {
            List<String> memberTypes;
            List<String> values = this.hmTypeRestr.get(ae.type);
            if (values != null) {
                for (String v : values) {
                    ae.alValues.add(v);
                }
            }
            if ((memberTypes = this.hmMemberTypeRestr.get(ae.type)) != null) {
                for (String type : memberTypes) {
                    List<String> memberTypeValues = this.hmTypeRestr.get(type);
                    if (memberTypeValues == null) continue;
                    for (String v : memberTypeValues) {
                        ma.values.add(v);
                    }
                }
            }
        }
        for (int k = 0; k < ae.alValues.size(); ++k) {
            ma.values.add(ae.alValues.get(k));
        }
        return ma;
    }

    public String getUnqualifiedName(String qname) {
        int pos = qname.indexOf(58);
        if (pos < 0) {
            return qname;
        }
        return qname.substring(pos + 1);
    }
}

