/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.AttributeEntry;
import org.fao.geonet.kernel.schema.BaseHandler;
import org.fao.geonet.kernel.schema.ComplexContentEntry;
import org.fao.geonet.kernel.schema.ElementEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.fao.geonet.kernel.schema.SimpleContentEntry;
import org.jdom.Attribute;
import org.jdom.Element;

class ComplexTypeEntry
extends BaseHandler {
    public String name;
    public boolean isOrType = false;
    public boolean isAbstract;
    public ComplexContentEntry complexContent;
    public SimpleContentEntry simpleContent;
    public List<ElementEntry> alElements = new ArrayList<ElementEntry>();
    public List<AttributeEntry> alAttribs = new ArrayList<AttributeEntry>();
    public List<String> alAttribGroups = new ArrayList<String>();

    public ComplexTypeEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public ComplexTypeEntry(ElementInfo ei) {
        this.handleAttribs(ei);
        this.handleChildren(ei);
    }

    private void handleAttribs(ElementInfo ei) {
        List attribs = ei.element.getAttributes();
        for (Object attrib : attribs) {
            Attribute at = (Attribute)attrib;
            String attrName = at.getName();
            if (attrName.equals("name")) {
                this.name = at.getValue();
                if (this.name.indexOf(58) != -1 || ei.targetNSPrefix == null) continue;
                this.name = ei.targetNSPrefix + ":" + at.getValue();
                continue;
            }
            if (!attrName.equals("abstract")) continue;
            String abValue = at.getValue();
            this.isAbstract = abValue.equals("true");
        }
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Object aChildren : children) {
            Element elChild = (Element)aChildren;
            String elName = elChild.getName();
            boolean first = true;
            if (elName.equals("sequence") || elName.equals("choice")) {
                this.isOrType = elName.equals("choice") && first;
                List sequence = elChild.getChildren();
                for (Object aSequence : sequence) {
                    Element elElem = (Element)aSequence;
                    if (this.isChoiceOrElementOrGroupOrSequence(elElem)) {
                        this.alElements.add(new ElementEntry(elElem, ei.file, ei.targetNS, ei.targetNSPrefix));
                        continue;
                    }
                    Logger.log();
                }
                continue;
            }
            if (elName.equals("group")) {
                first = false;
                this.isOrType = false;
                this.alElements.add(new ElementEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elName.equals("attribute")) {
                first = false;
                this.alAttribs.add(new AttributeEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elName.equals("attributeGroup")) {
                first = false;
                String attribGroup = elChild.getAttributeValue("ref");
                if (attribGroup == null) {
                    throw new IllegalArgumentException("'ref' is null for <attributeGroup> in complexType : " + this.name);
                }
                this.alAttribGroups.add(attribGroup);
                continue;
            }
            if (elName.equals("complexContent")) {
                first = false;
                this.complexContent = new ComplexContentEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                continue;
            }
            if (elName.equals("simpleContent")) {
                first = false;
                this.simpleContent = new SimpleContentEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                continue;
            }
            if (elName.equals("annotation")) continue;
            Logger.log();
        }
    }
}

