/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.region;

import java.util.Collections;
import java.util.Map;
import org.fao.geonet.utils.Log;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Content;
import org.jdom.Element;

public class Region {
    public static final String REGION_EL = "region";
    public static final CoordinateReferenceSystem WGS84;
    private static final String ID_ATT = "id";
    private static final String HAS_GEOM_ATT = "hasGeom";
    private static final String CATEGORY_ID_ATT = "categoryId";
    private static final String NORTH_EL = "north";
    private static final String SOUTH_EL = "south";
    private static final String EAST_EL = "east";
    private static final String WEST_EL = "west";
    private static final String LABEL_EL = "label";
    private static final String CATEGORY_EL = "categoryLabel";
    private final String id;
    private final Map<String, String> labels;
    private final String categoryId;
    private final Map<String, String> categoryLabels;
    private final boolean hasGeom;
    private final ReferencedEnvelope bbox;
    private volatile ReferencedEnvelope latlongBbox;

    public Region(String id, Map<String, String> labels, String categoryId, Map<String, String> categoryLabels, boolean hasGeom, ReferencedEnvelope bbox) {
        this.id = id;
        this.labels = Collections.unmodifiableMap(labels);
        this.categoryId = categoryId;
        this.categoryLabels = Collections.unmodifiableMap(categoryLabels);
        this.hasGeom = hasGeom;
        this.bbox = bbox;
    }

    public static CoordinateReferenceSystem decodeCRS(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem mapCRS = srs.equals("EPSG:4326") ? WGS84 : CRS.decode((String)srs, (boolean)false);
        return mapCRS;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public Map<String, String> getCategoryLabels() {
        return this.categoryLabels;
    }

    public boolean hasGeom() {
        return this.hasGeom;
    }

    public ReferencedEnvelope getBBox() {
        return this.bbox;
    }

    public ReferencedEnvelope getBBox(CoordinateReferenceSystem projection) throws TransformException, FactoryException {
        return this.bbox.transform(projection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getLatLongBBox() throws TransformException, FactoryException {
        if (this.latlongBbox == null) {
            ReferencedEnvelope referencedEnvelope = this.bbox;
            synchronized (referencedEnvelope) {
                if (this.latlongBbox == null) {
                    this.latlongBbox = this.bbox.transform(WGS84, true);
                }
            }
        }
        return this.latlongBbox;
    }

    public String toString() {
        String label = this.labels.get("eng");
        if (label == null && !this.labels.isEmpty()) {
            label = this.labels.values().iterator().next();
        }
        return this.categoryId + ":" + label;
    }

    public Element toElement() throws TransformException, FactoryException {
        Element regionEl = new Element(REGION_EL);
        regionEl.setAttribute(ID_ATT, this.getId());
        regionEl.setAttribute(CATEGORY_ID_ATT, this.getCategoryId());
        regionEl.setAttribute(HAS_GEOM_ATT, Boolean.toString(this.hasGeom()));
        regionEl.addContent((Content)new Element(ID_ATT).setText(this.getId()));
        ReferencedEnvelope bbox = this.getLatLongBBox();
        regionEl.addContent((Content)new Element(NORTH_EL).setText(Double.toString(bbox.getMaxY())));
        regionEl.addContent((Content)new Element(SOUTH_EL).setText(Double.toString(bbox.getMinY())));
        regionEl.addContent((Content)new Element(WEST_EL).setText(Double.toString(bbox.getMinX())));
        regionEl.addContent((Content)new Element(EAST_EL).setText(Double.toString(bbox.getMaxX())));
        Element labelEl = new Element(LABEL_EL);
        regionEl.addContent((Content)labelEl);
        for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
            labelEl.addContent((Content)new Element(entry.getKey()).setText(entry.getValue()));
        }
        Element categoryEl = new Element(CATEGORY_EL);
        regionEl.addContent((Content)categoryEl);
        for (Map.Entry<String, String> entry : this.getCategoryLabels().entrySet()) {
            categoryEl.addContent((Content)new Element(entry.getKey()).setText(entry.getValue()));
        }
        return regionEl;
    }

    static {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        try {
            crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.region", (String)"Unable to create latlong crs, something is wrong with Geotools dependencies", (Throwable)e);
        }
        WGS84 = crs;
    }
}

