/*
 * Decompiled with CFR 0.152.
 */
package jeeves;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.fao.geonet.JeevesJCS;

public class JeevesCacheManager {
    private static final String TEN_SECOND_KEY = "JeevesCacheManagerTenSeconds";
    private static final String ETERNAL_KEY = "JeevesCacheManagerETERNAL";
    private static Map<String, Lock> locks = new HashMap<String, Lock>();

    public static <V> V findInTenSecondCache(String key, Callable<V> loader) throws Exception {
        return JeevesCacheManager.find(TEN_SECOND_KEY, key, loader);
    }

    public static <V> V findInEternalCache(String key, Callable<V> loader) throws Exception {
        return JeevesCacheManager.find(ETERNAL_KEY, key, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V find(String cacheName, String key, Callable<V> loader) throws Exception {
        Lock lock = JeevesCacheManager.getLock(key);
        try {
            if (!lock.tryLock(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out trying to get the log for the JeevesCache");
            }
            JeevesJCS cache = JeevesJCS.getInstance((String)cacheName);
            Object value = cache.get((Object)key);
            if (value == null && (value = loader.call()) != null) {
                cache.put((Object)key, value);
            }
            Object object = value;
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    private static synchronized Lock getLock(String key) {
        Lock lock = locks.get(key);
        if (lock == null) {
            lock = new ReentrantLock();
            locks.put(key, lock);
        }
        return lock;
    }
}

