/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.FeatureTypeRegistry;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.data.wfs.impl.WFSContentComplexFeatureSource;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.complex.GmlFeatureTypeRegistryConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.complex.FeatureTypeRegistryConfiguration;

public class WFSContentDataAccess
implements DataAccess<FeatureType, Feature> {
    private final WFSClient client;
    private EmfComplexFeatureReader schemaParser;
    private FeatureTypeRegistry typeRegistry;
    private File cacheLocation;
    private final Map<Name, QName> names;
    protected String namespaceURI;
    private static Logger LOGGER = Logging.getLogger(WFSContentDataAccess.class);

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public WFSContentDataAccess(WFSClient client) {
        this.client = client;
        this.names = new ConcurrentHashMap<Name, QName>();
    }

    public ServiceInfo getInfo() {
        return this.client.getInfo();
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support createSchema.");
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support update schema.");
    }

    public List<Name> getNames() throws IOException {
        Set<QName> remoteTypeNames = this.client.getRemoteTypeNames();
        ArrayList<Name> namesList = new ArrayList<Name>(remoteTypeNames.size());
        for (QName remoteTypeName : remoteTypeNames) {
            NameImpl typeName = new NameImpl(remoteTypeName);
            namesList.add((Name)typeName);
            this.names.put((Name)typeName, remoteTypeName);
        }
        return namesList;
    }

    public QName getRemoteTypeName(Name localTypeName) throws IOException {
        QName qName;
        if (this.names.isEmpty()) {
            this.getNames();
        }
        if (null == (qName = this.names.get(localTypeName))) {
            throw new NoSuchElementException(localTypeName.toString());
        }
        return qName;
    }

    public FeatureType getSchema(Name name) throws IOException {
        if (this.names.isEmpty()) {
            this.getNames();
        }
        QName qname = this.names.get(name);
        URL describeRequestURL = this.client.getDescribeFeatureTypeGetURL(qname);
        FeatureTypeRegistry typeRegistry = this.getFeatureTypeRegistry();
        SchemaIndex schemaIndex = this.getSchemaParser().parse(describeRequestURL);
        typeRegistry.addSchemas(schemaIndex);
        AttributeDescriptor attributeDescriptor = typeRegistry.getDescriptor(name, null);
        return (FeatureType)attributeDescriptor.getType();
    }

    public void setCacheLocation(File cacheLocation) {
        if (this.schemaParser != null && this.cacheLocation == null) {
            this.deleteTemporaryCache();
            this.schemaParser = null;
            this.typeRegistry = null;
        }
        this.cacheLocation = cacheLocation;
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        WFSContentComplexFeatureSource contentComplexFeatureSource = new WFSContentComplexFeatureSource(typeName, this.client, this);
        return contentComplexFeatureSource;
    }

    private void deleteTemporaryCache() {
        SchemaCache cache;
        if (this.schemaParser.getResolver() != null && (cache = this.schemaParser.getResolver().getCache()) != null) {
            try {
                FileUtils.deleteDirectory((File)cache.getDirectory());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to delete temporary directory used for wfs schema cache.", e);
            }
        }
    }

    public void dispose() {
        if (this.cacheLocation == null && this.schemaParser != null) {
            this.deleteTemporaryCache();
        }
        this.schemaParser = null;
        this.typeRegistry = null;
    }

    protected EmfComplexFeatureReader getSchemaParser() {
        if (this.schemaParser == null) {
            this.schemaParser = EmfComplexFeatureReader.newInstance();
            SchemaResolver appSchemaResolver = null;
            if (this.cacheLocation == null) {
                File temporaryCache = new File(FileUtils.getTempDirectory(), "wfs_cache_" + RandomStringUtils.secure().nextAlphanumeric(5));
                if (temporaryCache.mkdir()) {
                    appSchemaResolver = new SchemaResolver(new SchemaCache(temporaryCache, true, true));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using temporary cache: " + temporaryCache.getAbsolutePath());
                    }
                } else {
                    LOGGER.warning("Couldn't create temporary directory for wfs cache at location: " + temporaryCache.getAbsolutePath());
                }
            } else {
                appSchemaResolver = new SchemaResolver(new SchemaCache(this.cacheLocation, true, true));
            }
            if (appSchemaResolver != null) {
                this.schemaParser.setResolver(appSchemaResolver);
            }
        }
        return this.schemaParser;
    }

    private FeatureTypeRegistry getFeatureTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new FeatureTypeRegistry((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), (FeatureTypeRegistryConfiguration)new GmlFeatureTypeRegistryConfiguration(null));
        }
        return this.typeRegistry;
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support remove schema.");
    }
}

