/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class StatsAggregator
extends NumericMetricsAggregator.MultiValue {
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;

    StatsAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
        this.counts = this.bigArrays().newLongArray(1L, true);
        this.sums = this.bigArrays().newDoubleArray(1L, true);
        this.compensations = this.bigArrays().newDoubleArray(1L, true);
        this.mins = this.bigArrays().newDoubleArray(1L, false);
        this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        this.maxes = this.bigArrays().newDoubleArray(1L, false);
        this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        this.format = config.format();
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= StatsAggregator.this.counts.size()) {
                    long from = StatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    StatsAggregator.this.counts = StatsAggregator.this.bigArrays().resize(StatsAggregator.this.counts, overSize);
                    StatsAggregator.this.sums = StatsAggregator.this.bigArrays().resize(StatsAggregator.this.sums, overSize);
                    StatsAggregator.this.compensations = StatsAggregator.this.bigArrays().resize(StatsAggregator.this.compensations, overSize);
                    StatsAggregator.this.mins = StatsAggregator.this.bigArrays().resize(StatsAggregator.this.mins, overSize);
                    StatsAggregator.this.maxes = StatsAggregator.this.bigArrays().resize(StatsAggregator.this.maxes, overSize);
                    StatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    StatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    StatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = StatsAggregator.this.mins.get(bucket);
                    double max = StatsAggregator.this.maxes.get(bucket);
                    double sum = StatsAggregator.this.sums.get(bucket);
                    double compensation = StatsAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    StatsAggregator.this.sums.set(bucket, kahanSummation.value());
                    StatsAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    StatsAggregator.this.mins.set(bucket, min);
                    StatsAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        return InternalStats.Metrics.hasMetric(name);
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (owningBucketOrd >= this.counts.size()) {
            return switch (InternalStats.Metrics.resolve(name)) {
                default -> throw new IncompatibleClassChangeError();
                case InternalStats.Metrics.count, InternalStats.Metrics.sum -> 0.0;
                case InternalStats.Metrics.min -> Double.POSITIVE_INFINITY;
                case InternalStats.Metrics.max -> Double.NEGATIVE_INFINITY;
                case InternalStats.Metrics.avg -> Double.NaN;
            };
        }
        return switch (InternalStats.Metrics.resolve(name)) {
            default -> throw new IncompatibleClassChangeError();
            case InternalStats.Metrics.count -> this.counts.get(owningBucketOrd);
            case InternalStats.Metrics.sum -> this.sums.get(owningBucketOrd);
            case InternalStats.Metrics.min -> this.mins.get(owningBucketOrd);
            case InternalStats.Metrics.max -> this.maxes.get(owningBucketOrd);
            case InternalStats.Metrics.avg -> this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalStats.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.maxes, this.mins, this.sums, this.compensations});
    }
}

