/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.xcontent.ToXContent;

public record ScriptCacheStats(Map<String, ScriptStats> context, ScriptStats general) implements Writeable,
ChunkedToXContent
{
    public ScriptCacheStats(Map<String, ScriptStats> context) {
        this(Collections.unmodifiableMap(context), null);
    }

    public ScriptCacheStats(ScriptStats general) {
        this(null, Objects.requireNonNull(general));
    }

    public static ScriptCacheStats read(StreamInput in) throws IOException {
        boolean isContext = in.readBoolean();
        if (!isContext) {
            return new ScriptCacheStats(ScriptStats.read(in));
        }
        int size = in.readInt();
        Map<String, ScriptStats> context = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            context.put(name, ScriptStats.read(in));
        }
        return new ScriptCacheStats(context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.general != null) {
            out.writeBoolean(false);
            this.general.writeTo(out);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.context.size());
        for (String name : this.context.keySet().stream().sorted().toList()) {
            out.writeString(name);
            this.context.get(name).writeTo(out);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(ChunkedToXContentHelper.startObject("script_cache"), ChunkedToXContentHelper.startObject("sum"), this.general != null ? Iterators.concat(ChunkedToXContentHelper.field("compilations", this.general.getCompilations()), ChunkedToXContentHelper.field("cache_evictions", this.general.getCacheEvictions()), ChunkedToXContentHelper.field("compilation_limit_triggered", this.general.getCompilationLimitTriggered()), ChunkedToXContentHelper.endObject(), ChunkedToXContentHelper.endObject()) : Iterators.concat(Iterators.single((builder, params) -> {
            ScriptStats sum = this.sum();
            return builder.field("compilations", sum.getCompilations()).field("cache_evictions", sum.getCacheEvictions()).field("compilation_limit_triggered", sum.getCompilationLimitTriggered()).endObject();
        }), ChunkedToXContentHelper.startArray("contexts"), Iterators.flatMap(this.context.keySet().stream().sorted().iterator(), ctx -> {
            ScriptStats stats = this.context.get(ctx);
            return Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.field("context", ctx), ChunkedToXContentHelper.field("compilations", stats.getCompilations()), ChunkedToXContentHelper.field("cache_evictions", stats.getCacheEvictions()), ChunkedToXContentHelper.field("compilation_limit_triggered", stats.getCompilationLimitTriggered()), ChunkedToXContentHelper.endObject());
        }), ChunkedToXContentHelper.endArray(), ChunkedToXContentHelper.endObject()));
    }

    public Map<String, ScriptStats> getContextStats() {
        return this.context;
    }

    public ScriptStats getGeneralStats() {
        return this.general;
    }

    public ScriptStats sum() {
        if (this.general != null) {
            return this.general;
        }
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptStats stat : this.context.values()) {
            compilations += stat.getCompilations();
            cacheEvictions += stat.getCacheEvictions();
            compilationLimitTriggered += stat.getCompilationLimitTriggered();
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered, null, null);
    }

    static final class Fields {
        static final String SCRIPT_CACHE_STATS = "script_cache";
        static final String CONTEXT = "context";
        static final String SUM = "sum";
        static final String CONTEXTS = "contexts";

        Fields() {
        }
    }
}

