/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.http.HttpRouteStats;
import org.elasticsearch.http.HttpRouteStatsTracker;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, Map<RestApiVersion, RestHandler>> methodHandlers;
    private final HttpRouteStatsTracker statsTracker = new HttpRouteStatsTracker();

    MethodHandlers(String path) {
        this.path = path;
        this.methodHandlers = new EnumMap<RestRequest.Method, Map<RestApiVersion, RestHandler>>(RestRequest.Method.class);
    }

    public String getPath() {
        return this.path;
    }

    MethodHandlers addMethod(RestRequest.Method method, RestApiVersion version, RestHandler handler) {
        RestHandler existing = this.methodHandlers.computeIfAbsent(method, k -> new EnumMap(RestApiVersion.class)).putIfAbsent(version, handler);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + method);
        }
        return this;
    }

    RestHandler getHandler(RestRequest.Method method, RestApiVersion version) {
        Map<RestApiVersion, RestHandler> versionToHandlers = this.methodHandlers.get((Object)method);
        if (versionToHandlers == null) {
            return null;
        }
        RestHandler handler = versionToHandlers.get(version);
        return handler == null ? versionToHandlers.get(RestApiVersion.current()) : handler;
    }

    Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }

    public void addRequestStats(int contentLength) {
        this.statsTracker.addRequestStats(contentLength);
    }

    public void addResponseStats(long contentLength) {
        this.statsTracker.addResponseStats(contentLength);
    }

    public void addResponseTime(long timeMillis) {
        this.statsTracker.addResponseTime(timeMillis);
    }

    public HttpRouteStats getStats() {
        return this.statsTracker.getStats();
    }
}

