/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;

public class IpPrefixAutomatonUtil {
    private static final Automaton EMPTY_AUTOMATON = Automata.makeEmpty();
    private static final Automaton IPV4_PREFIX = Automata.makeBinary((BytesRef)new BytesRef(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}));
    static final Map<Integer, Automaton> INCOMPLETE_IP4_GROUP_AUTOMATON_LOOKUP = new HashMap<Integer, Automaton>();
    private static Pattern IPV4_GROUP_MATCHER;
    private static Pattern ONLY_ZEROS;
    private static Pattern IP6_BLOCK_MATCHER;

    static CompiledAutomaton buildIpPrefixAutomaton(String ipPrefix) {
        Automaton result;
        if (!ipPrefix.isEmpty()) {
            Automaton ipv4Automaton = IpPrefixAutomatonUtil.createIp4Automaton(ipPrefix);
            if (ipv4Automaton != null) {
                ipv4Automaton = Operations.concatenate((Automaton)IPV4_PREFIX, (Automaton)ipv4Automaton);
            }
            Automaton ipv6Automaton = IpPrefixAutomatonUtil.getIpv6Automaton(ipPrefix);
            result = Operations.union((Automaton)ipv4Automaton, (Automaton)ipv6Automaton);
        } else {
            result = Automata.makeAnyBinary();
        }
        result = MinimizationOperations.minimize((Automaton)result, (int)10000);
        return new CompiledAutomaton(result, null, false, 0, true);
    }

    private static Automaton getIpv6Automaton(String ipPrefix) {
        Automaton ipv6Automaton = EMPTY_AUTOMATON;
        List<String> ip6Groups = IpPrefixAutomatonUtil.parseIp6Prefix(ipPrefix);
        if (!ip6Groups.isEmpty()) {
            ipv6Automaton = Automata.makeString((String)"");
            int groupsAdded = 0;
            for (String group : ip6Groups) {
                if (group.contains(".")) {
                    if (groupsAdded > 0) {
                        ipv6Automaton = Operations.concatenate((Automaton)ipv6Automaton, (Automaton)IpPrefixAutomatonUtil.createIp4Automaton(group));
                        groupsAdded += 2;
                        continue;
                    }
                    return EMPTY_AUTOMATON;
                }
                if (group.endsWith(":")) {
                    ++groupsAdded;
                    if (group.length() > 1) {
                        group = group.substring(0, group.length() - 1);
                        ipv6Automaton = Operations.concatenate((Automaton)ipv6Automaton, (Automaton)IpPrefixAutomatonUtil.automatonFromIPv6Group(IpPrefixAutomatonUtil.padWithZeros(group, 4 - group.length())));
                        continue;
                    }
                    ipv6Automaton = Operations.concatenate((Automaton)ipv6Automaton, (Automaton)Operations.repeat((Automaton)Automata.makeChar((int)0)));
                    continue;
                }
                if (groupsAdded == 0 && ONLY_ZEROS.matcher(group).matches()) {
                    return EMPTY_AUTOMATON;
                }
                ++groupsAdded;
                ipv6Automaton = Operations.concatenate((Automaton)ipv6Automaton, (Automaton)IpPrefixAutomatonUtil.automatonFromIPv6Group(group));
            }
            for (int i = 0; i < 16 - groupsAdded * 2; ++i) {
                ipv6Automaton = Operations.concatenate((Automaton)ipv6Automaton, (Automaton)Operations.optional((Automaton)Automata.makeCharRange((int)0, (int)255)));
            }
        }
        return ipv6Automaton;
    }

    static Automaton automatonFromIPv6Group(String ipv6Group) {
        assert (ipv6Group.length() > 0 && ipv6Group.length() <= 4) : "expected a full ipv6 group or prefix";
        Automaton result = Automata.makeString((String)"");
        for (int leadingZeros = 0; leadingZeros <= 4 - ipv6Group.length(); ++leadingZeros) {
            int bytesAdded = 0;
            String padded = IpPrefixAutomatonUtil.padWithZeros(ipv6Group, leadingZeros);
            Automaton a = Automata.makeString((String)"");
            while (padded.length() >= 2) {
                a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeChar((int)Integer.parseInt(padded.substring(0, 2), 16)));
                padded = padded.substring(2);
                ++bytesAdded;
            }
            if (padded.length() == 1) {
                int value = Integer.parseInt(padded, 16);
                a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeCharRange((int)(value * 16), (int)(value * 16 + 15)));
                ++bytesAdded;
            }
            if (bytesAdded != 2) {
                a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeCharRange((int)0, (int)255));
            }
            result = Operations.union((Automaton)result, (Automaton)a);
        }
        return result;
    }

    static Automaton createIp4Automaton(String prefix) {
        Matcher ip4Matcher = IPV4_GROUP_MATCHER.matcher(prefix);
        if (!ip4Matcher.matches()) {
            return EMPTY_AUTOMATON;
        }
        int prefixBytes = 0;
        byte[] completeByteGroups = new byte[4];
        int completeBytes = 0;
        Automaton incompleteGroupAutomaton = Automata.makeString((String)"");
        for (int g = 1; g <= 4; ++g) {
            String group = ip4Matcher.group(g);
            if (group == null) continue;
            if (group.endsWith(".")) {
                int value = Integer.parseInt(group.substring(0, group.length() - 1));
                if (value < 0 || value > 255) {
                    return EMPTY_AUTOMATON;
                }
                completeByteGroups[completeBytes] = (byte)value;
                ++completeBytes;
                ++prefixBytes;
                continue;
            }
            int numberPrefix = Integer.parseInt(group);
            if (numberPrefix <= 255) {
                incompleteGroupAutomaton = INCOMPLETE_IP4_GROUP_AUTOMATON_LOOKUP.get(numberPrefix);
                ++prefixBytes;
                continue;
            }
            return EMPTY_AUTOMATON;
        }
        return Operations.concatenate(List.of(Automata.makeBinary((BytesRef)new BytesRef(completeByteGroups, 0, completeBytes)), incompleteGroupAutomaton, Operations.repeat((Automaton)Automata.makeCharRange((int)0, (int)255), (int)(4 - prefixBytes), (int)(4 - prefixBytes))));
    }

    private static String padWithZeros(String input, int leadingZeros) {
        return "0".repeat(leadingZeros) + input;
    }

    static List<String> parseIp6Prefix(String ip6Prefix) {
        Matcher ip6blockMatcher = IP6_BLOCK_MATCHER.matcher(ip6Prefix);
        int position = 0;
        ArrayList<String> groups = new ArrayList<String>();
        while (ip6blockMatcher.find(position)) {
            if (ip6blockMatcher.start() == position) {
                position = ip6blockMatcher.end();
                IntStream.rangeClosed(1, 3).mapToObj(i -> ip6blockMatcher.group(i)).filter(s -> s != null).forEach(groups::add);
                continue;
            }
            return Collections.emptyList();
        }
        if (position != ip6Prefix.length()) {
            return Collections.emptyList();
        }
        return groups;
    }

    static {
        for (int c = 0; c <= 255; ++c) {
            Automaton a = Automata.makeChar((int)c);
            if (c > 0 && c < 10) {
                a = Operations.union((Automaton)a, (Automaton)Automata.makeCharRange((int)(c * 10), (int)(c * 10 + 9)));
                if (c == 1) {
                    a = Operations.union((Automaton)a, (Automaton)Automata.makeCharRange((int)100, (int)199));
                }
                if (c == 2) {
                    a = Operations.union((Automaton)a, (Automaton)Automata.makeCharRange((int)200, (int)255));
                }
            }
            if (c >= 10 && c < 26) {
                int min = c * 10;
                int max = Math.min(c * 10 + 9, 255);
                a = Operations.union((Automaton)a, (Automaton)Automata.makeCharRange((int)min, (int)max));
            }
            INCOMPLETE_IP4_GROUP_AUTOMATON_LOOKUP.put(c, a);
        }
        IPV4_GROUP_MATCHER = Pattern.compile("^((?:0|[1-9][0-9]{0,2})\\.)?((?:0|[1-9][0-9]{0,2})\\.)?((?:0|[1-9][0-9]{0,2})\\.)?((?:0|[1-9][0-9]{0,2}))?$");
        ONLY_ZEROS = Pattern.compile("^0+$");
        IP6_BLOCK_MATCHER = Pattern.compile("([a-f0-9]{0,4}:)|([a-f0-9]{1,4}$)|((?:(?:0|[1-9][0-9]{0,2})\\.){1,3}(?:0|[1-9][0-9]{0,2})?$)");
    }
}

