/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.TaskExecutor;
import org.elasticsearch.index.codec.vectors.ES814ScalarQuantizedVectorsFormat;

public final class ES814HnswScalarQuantizedVectorsFormat
extends KnnVectorsFormat {
    static final String NAME = "ES814HnswScalarQuantizedVectorsFormat";
    static final int MAXIMUM_MAX_CONN = 512;
    static final int MAXIMUM_BEAM_WIDTH = 3200;
    private final int maxConn;
    private final int beamWidth;
    private final ES814ScalarQuantizedVectorsFormat flatVectorsFormat;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;

    public ES814HnswScalarQuantizedVectorsFormat() {
        this(16, 100, 1, null, null);
    }

    public ES814HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth, int numMergeWorkers, Float confidenceInterval, ExecutorService mergeExec) {
        super(NAME);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers > 1 && mergeExec == null) {
            throw new IllegalArgumentException("No executor service passed in when " + numMergeWorkers + " merge workers are requested");
        }
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor((Executor)mergeExec) : null;
        this.flatVectorsFormat = new ES814ScalarQuantizedVectorsFormat(confidenceInterval);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, this.flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, this.flatVectorsFormat.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "ES814HnswScalarQuantizedVectorsFormat(name=ES814HnswScalarQuantizedVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + this.flatVectorsFormat + ")";
    }
}

