/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.time.Instant;

public class TimestampBounds {
    private final long startTime;
    private final long endTime;

    public static TimestampBounds updateEndTime(TimestampBounds current, Instant newEndTime) {
        long newEndTimeMillis = newEndTime.toEpochMilli();
        if (current.endTime > newEndTimeMillis) {
            throw new IllegalArgumentException("index.time_series.end_time must be larger than current value [" + current.endTime + "] but was [" + newEndTime + "]");
        }
        return new TimestampBounds(current.startTime(), newEndTimeMillis);
    }

    public TimestampBounds(Instant startTime, Instant endTime) {
        this(startTime.toEpochMilli(), endTime.toEpochMilli());
    }

    private TimestampBounds(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public String toString() {
        return this.startTime + "-" + this.endTime;
    }
}

