/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.AliasFilter;

public class ShardValidateQueryRequest
extends BroadcastShardRequest {
    private QueryBuilder query;
    private boolean explain;
    private boolean rewrite;
    private long nowInMillis;
    private AliasFilter filteringAliases;

    public ShardValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        int typesSize;
        this.query = in.readNamedWriteable(QueryBuilder.class);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (typesSize = in.readVInt()) > 0) {
            for (int i = 0; i < typesSize; ++i) {
                in.readString();
            }
        }
        this.filteringAliases = AliasFilter.readFrom(in);
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.nowInMillis = in.readVLong();
    }

    public ShardValidateQueryRequest(ShardId shardId, AliasFilter filteringAliases, ValidateQueryRequest request) {
        super(shardId, request);
        this.query = request.query();
        this.explain = request.explain();
        this.rewrite = request.rewrite();
        this.filteringAliases = Objects.requireNonNull(filteringAliases, "filteringAliases must not be null");
        this.nowInMillis = request.nowInMillis;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public AliasFilter filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable(this.query);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeVInt(0);
        }
        this.filteringAliases.writeTo(out);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeVLong(this.nowInMillis);
    }
}

