/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.entitylistener.MetadataIdentifierTemplateListenerManager;

@Entity
@Table(name="MetadataIdentifierTemplate")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={MetadataIdentifierTemplateListenerManager.class})
@SequenceGenerator(name="metadata_identifier_template_id_seq", initialValue=100, allocationSize=1)
public class MetadataIdentifierTemplate
extends GeonetEntity {
    static final String ID_SEQ_NAME = "metadata_identifier_template_id_seq";
    private int _id;
    private String _name;
    private String _template;
    private char _systemProvided = (char)110;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadata_identifier_template_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this._id;
    }

    public MetadataIdentifierTemplate setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this._name;
    }

    public MetadataIdentifierTemplate setName(String name) {
        this._name = name;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getTemplate() {
        return this._template;
    }

    public MetadataIdentifierTemplate setTemplate(String template) {
        this._template = template;
        return this;
    }

    @Transient
    public boolean isSystemProvided() {
        return Constants.toBoolean_fromYNChar(this.getSystemProvided_JPAWorkaround());
    }

    public void setSystemDefault(boolean isSystemProvided) {
        this.setSystemProvided_JPAWorkaround(Constants.toYN_EnabledChar(isSystemProvided));
    }

    @Column(name="isprovided", length=1, nullable=false, columnDefinition="Char(1) default 'n'")
    protected char getSystemProvided_JPAWorkaround() {
        return this._systemProvided;
    }

    protected void setSystemProvided_JPAWorkaround(char _default) {
        this._systemProvided = _default;
    }
}

