/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SVGTileRenderer
extends TileRenderer {
    public static final Logger LOGGER = LogManager.getLogger(SVGTileRenderer.class);
    private static Document svgZoomOut;

    private static void makeSvgZoomOut() {
        DOMParser parser = new DOMParser();
        String svgZoomFileName = "svgZoomOut.xsl";
        InputStream stream = SVGTileRenderer.class.getResourceAsStream(svgZoomFileName);
        if (stream == null) {
            String file = SVGTileRenderer.class.getResource(".").getPath() + svgZoomFileName;
            throw new RuntimeException("Cannot find the SVG transformation XSLT: expected it to be in: " + file);
        }
        try {
            InputSource inputSource = new InputSource(stream);
            inputSource.setSystemId(".");
            parser.parse(inputSource);
            svgZoomOut = parser.getDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse the SVG transformation XSLT", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void render(final Transformer transformer, List<URI> uris, ParallelMapTileLoader parallelMapTileLoader, final RenderingContext context, final float opacity, int nbTilesHorizontal, double offsetX, double offsetY, long bitmapTileW, long bitmapTileH) throws IOException {
        if (uris.size() != 1) {
            throw new InvalidValueException("format", "application/x-pdf");
        }
        final URI uri = uris.get(0);
        parallelMapTileLoader.addTileToLoad(new MapTileTask(){
            public PrintTranscoder pt;

            @Override
            protected void readTile() throws IOException, DocumentException {
                LOGGER.debug((Object)uri);
                TranscoderInput ti = SVGTileRenderer.this.getTranscoderInput(uri.toURL(), transformer, context);
                if (ti != null) {
                    this.pt = new PrintTranscoder();
                    this.pt.transcode(ti, null);
                }
            }

            @Override
            protected void renderOnPdf(PdfContentByte dc) throws DocumentException {
                dc.transform(transformer.getSvgTransform());
                if ((double)opacity < 1.0) {
                    PdfGState gs = new PdfGState();
                    gs.setFillOpacity(opacity);
                    gs.setStrokeOpacity(opacity);
                    dc.setGState(gs);
                }
                PdfGraphics2D g2 = new PdfGraphics2D(dc, (float)transformer.getRotatedSvgW(), (float)transformer.getRotatedSvgH());
                System.setProperty("org.apache.batik.warn_destination", "false");
                g2.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, (Object)"Printing");
                g2.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
                Paper paper = new Paper();
                paper.setSize(transformer.getRotatedSvgW(), transformer.getRotatedSvgH());
                paper.setImageableArea(0.0, 0.0, transformer.getRotatedSvgW(), transformer.getRotatedSvgH());
                PageFormat pf = new PageFormat();
                pf.setPaper(paper);
                this.pt.print((Graphics)g2, pf, 0);
                g2.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranscoderInput getTranscoderInput(URL url, Transformer transformer, RenderingContext context) {
        float zoomFactor = transformer.getSvgFactor() * context.getStyleFactor();
        if (svgZoomOut != null && zoomFactor != 1.0f) {
            javax.xml.transform.Transformer xslt = null;
            try {
                Document doc;
                DOMResult transformedSvg = new DOMResult();
                TransformerFactory factory = TransformerFactory.newInstance();
                if (svgZoomOut.getTextContent() == null) {
                    SVGTileRenderer.makeSvgZoomOut();
                }
                xslt = factory.newTransformer(new DOMSource(svgZoomOut));
                xslt.setParameter("zoomFactor", Float.valueOf(zoomFactor));
                URLConnection urlConnection = url.openConnection();
                for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                    urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                try (InputStream inputStream = urlConnection.getInputStream();){
                    xslt.transform(new StreamSource(inputStream), transformedSvg);
                    doc = (Document)transformedSvg.getNode();
                    if (LOGGER.isDebugEnabled()) {
                        SVGTileRenderer.printDom(doc);
                    }
                }
                return new TranscoderInput(doc);
            }
            catch (Exception e) {
                if (xslt == null) {
                    LOGGER.error("xslt = NULL, zoomFactor = " + zoomFactor + ", svgZoomOut = " + svgZoomOut + "\nsvgZoomOut.getTextContent() = " + svgZoomOut.getTextContent() + "\nsvgZoomOut.getChildNodes().getLength() = " + svgZoomOut.getChildNodes().getLength());
                }
                context.addError(e);
                return null;
            }
        }
        return new TranscoderInput(url.toString());
    }

    public static void printDom(Document doc) throws IOException {
        OutputFormat format = new OutputFormat(doc);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, format);
        serializer.serialize(doc);
        LOGGER.trace(((Object)out).toString());
        ((OutputStream)out).close();
    }

    static {
        SVGTileRenderer.makeSvgZoomOut();
    }
}

