/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomXPath {
    private static final Pattern NUMBER_UNIT = Pattern.compile("^(\\d*(\\.\\d*)?)(.*)$");

    public String factorArray(String valsTxt, int factor) {
        String[] vals = valsTxt.split("[,]\\s*");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            String val = vals[i];
            if (i > 0) {
                result.append(",");
            }
            result.append(this.factorValue(val, factor));
        }
        return result.toString();
    }

    public String factorValue(String valTxt, int factor) {
        Matcher matcher = NUMBER_UNIT.matcher(valTxt);
        if (matcher.matches()) {
            String s = matcher.group(1);
            String txt = String.valueOf(Float.parseFloat(s) * (float)factor);
            if (txt.endsWith(".0")) {
                txt = txt.substring(0, txt.length() - 2);
            }
            return txt + matcher.group(3);
        }
        throw new NumberFormatException("Cannot parse [" + valTxt + "]");
    }
}

