/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.geo;

import org.json.JSONException;
import org.json.JSONWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.geo.MfFeature;
import org.mapfish.geo.MfFeatureCollection;
import org.mapfish.geo.MfGeo;
import org.mapfish.geo.MfGeometry;

public class MfGeoJSONWriter {
    private final JSONWriter builder;

    public MfGeoJSONWriter(JSONWriter builder) {
        this.builder = builder;
    }

    public void encode(MfGeo o) throws JSONException {
        switch (o.getGeoType()) {
            case FEATURE: {
                MfFeature f = (MfFeature)o;
                this.encodeFeature(f);
                break;
            }
            case FEATURECOLLECTION: {
                MfFeatureCollection c = (MfFeatureCollection)o;
                this.encodeFeatureCollection(c);
                break;
            }
            case GEOMETRY: {
                MfGeometry g = (MfGeometry)o;
                this.encodeGeometry(g.getInternalGeometry());
                break;
            }
            default: {
                throw new RuntimeException("No implementation for " + o.getGeoType());
            }
        }
    }

    public void encodeFeatureCollection(MfFeatureCollection c) throws JSONException {
        this.builder.object();
        this.builder.key("type").value((Object)"FeatureCollection");
        this.builder.key("features");
        this.builder.array();
        for (MfFeature f : c.getCollection()) {
            this.encodeFeature(f);
        }
        this.builder.endArray();
        this.builder.endObject();
    }

    public void encodeFeature(MfFeature f) throws JSONException {
        Geometry g;
        this.builder.object();
        this.builder.key("type").value((Object)"Feature");
        this.builder.key("id").value((Object)f.getFeatureId());
        this.builder.key("geometry");
        MfGeometry mfg = f.getMfGeometry();
        if (mfg != null && (g = mfg.getInternalGeometry()) != null) {
            this.encodeGeometry(g);
        } else {
            this.builder.value(null);
        }
        this.builder.key("properties");
        this.builder.object();
        f.toJSON(this.builder);
        this.builder.endObject();
        this.builder.endObject();
    }

    public void encodeGeometry(Geometry g) throws JSONException {
        block10: {
            block9: {
                this.builder.object();
                this.builder.key("type");
                this.builder.value((Object)MfGeoJSONWriter.getGeometryName(g));
                GeometryType geometryType = MfGeoJSONWriter.getGeometryType(g);
                if (geometryType == GeometryType.MULTIGEOMETRY) break block9;
                this.builder.key("coordinates");
                switch (geometryType) {
                    case POINT: {
                        this.encodeCoordinate(g.getCoordinate());
                        break block10;
                    }
                    case LINESTRING: 
                    case MULTIPOINT: {
                        this.encodeCoordinates(g.getCoordinates());
                        break block10;
                    }
                    case POLYGON: {
                        this.encodePolygon((Polygon)g);
                        break block10;
                    }
                    case MULTILINESTRING: {
                        this.builder.array();
                        int n = g.getNumGeometries();
                        for (int i = 0; i < n; ++i) {
                            this.encodeCoordinates(g.getGeometryN(i).getCoordinates());
                        }
                        this.builder.endArray();
                        break block10;
                    }
                    case MULTIPOLYGON: {
                        this.builder.array();
                        int n = g.getNumGeometries();
                        for (int i = 0; i < n; ++i) {
                            this.encodePolygon((Polygon)g.getGeometryN(i));
                        }
                        this.builder.endArray();
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("No implementation for " + geometryType);
                    }
                }
            }
            this.encodeGeomCollection((GeometryCollection)g);
        }
        this.builder.endObject();
    }

    private void encodeGeomCollection(GeometryCollection collection) throws JSONException {
        this.builder.array();
        this.builder.key("geometries");
        int n = collection.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.encodeGeometry(collection.getGeometryN(i));
        }
        this.builder.endArray();
    }

    private void encodeCoordinates(Coordinate[] coords) throws JSONException {
        this.builder.array();
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coord = coords[i];
            this.encodeCoordinate(coord);
        }
        this.builder.endArray();
    }

    private void encodeCoordinate(Coordinate coord) throws JSONException {
        this.builder.array();
        this.builder.value(coord.x);
        this.builder.value(coord.y);
        this.builder.endArray();
    }

    protected void encodeBoundingBox(Envelope env) throws JSONException {
        this.builder.key("bbox");
        this.builder.array();
        this.builder.value(env.getMinX());
        this.builder.value(env.getMinY());
        this.builder.value(env.getMaxX());
        this.builder.value(env.getMaxY());
        this.builder.endArray();
    }

    private void encodePolygon(Polygon geometry) throws JSONException {
        this.builder.array();
        this.encodeCoordinates(geometry.getExteriorRing().getCoordinates());
        int ii = geometry.getNumInteriorRing();
        for (int i = 0; i < ii; ++i) {
            this.encodeCoordinates(geometry.getInteriorRingN(i).getCoordinates());
        }
        this.builder.endArray();
    }

    public static String getGeometryName(Geometry geometry) {
        GeometryType type = MfGeoJSONWriter.getGeometryType(geometry);
        return type != null ? type.getName() : null;
    }

    public static GeometryType getGeometryType(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        GeometryType returnValue = geomClass.equals(Point.class) ? GeometryType.POINT : (geomClass.equals(LineString.class) ? GeometryType.LINESTRING : (geomClass.equals(Polygon.class) ? GeometryType.POLYGON : (geomClass.equals(MultiPoint.class) ? GeometryType.MULTIPOINT : (geomClass.equals(MultiLineString.class) ? GeometryType.MULTILINESTRING : (geomClass.equals(MultiPolygon.class) ? GeometryType.MULTIPOLYGON : (geomClass.equals(GeometryCollection.class) ? GeometryType.MULTIGEOMETRY : null))))));
        return returnValue;
    }

    public static enum GeometryType {
        POINT("Point"),
        LINESTRING("LineString"),
        POLYGON("Polygon"),
        MULTIPOINT("MultiPoint"),
        MULTILINESTRING("MultiLineString"),
        MULTIPOLYGON("MultiPolygon"),
        MULTIGEOMETRY("GeometryCollection");

        private final String name;

        private GeometryType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

