/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public class RollbackEnd
implements Loggable {
    private long matchpointLSN;
    private long rollbackStartLSN;
    private Timestamp time;

    public RollbackEnd(long matchpointLSN, long rollbackStartLSN) {
        this.matchpointLSN = matchpointLSN;
        this.rollbackStartLSN = rollbackStartLSN;
        this.time = new Timestamp(System.currentTimeMillis());
    }

    public RollbackEnd() {
    }

    public long getMatchpoint() {
        return this.matchpointLSN;
    }

    public long getRollbackStart() {
        return this.rollbackStartLSN;
    }

    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.matchpointLSN) + LogUtils.getPackedLongLogSize(this.rollbackStartLSN) + LogUtils.getTimestampLogSize(this.time);
    }

    public void writeToLog(ByteBuffer buffer) {
        LogUtils.writePackedLong(buffer, this.matchpointLSN);
        LogUtils.writePackedLong(buffer, this.rollbackStartLSN);
        LogUtils.writeTimestamp(buffer, this.time);
    }

    public void readFromLog(ByteBuffer buffer, int entryVersion) {
        this.matchpointLSN = LogUtils.readPackedLong(buffer);
        this.rollbackStartLSN = LogUtils.readPackedLong(buffer);
        this.time = LogUtils.readTimestamp(buffer, false);
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(" matchpointLSN=");
        sb.append(DbLsn.getNoFormatString(this.matchpointLSN));
        sb.append(" rollbackStartLSN=");
        sb.append(DbLsn.getNoFormatString(this.rollbackStartLSN));
        sb.append(" time=").append(this.time);
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof RollbackEnd)) {
            return false;
        }
        RollbackEnd otherRE = (RollbackEnd)other;
        return this.rollbackStartLSN == otherRE.rollbackStartLSN && this.matchpointLSN == otherRE.matchpointLSN && this.time.equals(otherRE.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpLog(sb, true);
        return sb.toString();
    }
}

