/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PatternBank {
    public static PatternBank EMPTY = new PatternBank(Map.of());
    private final Map<String, String> bank;

    public PatternBank(Map<String, String> bank) {
        Objects.requireNonNull(bank, "bank must not be null");
        PatternBank.forbidCircularReferences(bank);
        this.bank = Collections.unmodifiableMap(new LinkedHashMap<String, String>(bank));
    }

    public String get(String patternName) {
        return this.bank.get(patternName);
    }

    public Map<String, String> bank() {
        return this.bank;
    }

    public PatternBank extendWith(Map<String, String> extraPatterns) {
        if (extraPatterns == null || extraPatterns.isEmpty()) {
            return this;
        }
        LinkedHashMap<String, String> extendedBank = new LinkedHashMap<String, String>(this.bank);
        extendedBank.putAll(extraPatterns);
        return new PatternBank(extendedBank);
    }

    static void forbidCircularReferences(Map<String, String> bank) {
        for (Map.Entry<String, String> entry : bank.entrySet()) {
            if (!PatternBank.patternReferencesItself(entry.getValue(), entry.getKey())) continue;
            throw new IllegalArgumentException("circular reference in pattern [" + entry.getKey() + "][" + entry.getValue() + "]");
        }
        for (Map.Entry<String, String> entry : bank.entrySet()) {
            String name = entry.getKey();
            String pattern = entry.getValue();
            PatternBank.innerForbidCircularReferences(bank, name, new ArrayList<String>(), pattern);
        }
    }

    private static void innerForbidCircularReferences(Map<String, String> bank, String patternName, List<String> path, String pattern) {
        if (PatternBank.patternReferencesItself(pattern, patternName)) {
            String message;
            if (path.isEmpty()) {
                message = "circular reference in pattern [" + patternName + "][" + pattern + "]";
            } else {
                message = "circular reference in pattern [" + path.remove(path.size() - 1) + "][" + pattern + "] back to pattern [" + patternName + "]";
                if (!path.isEmpty()) {
                    message = message + " via patterns [" + String.join((CharSequence)"=>", path) + "]";
                }
            }
            throw new IllegalArgumentException(message);
        }
        int i = pattern.indexOf("%{");
        while (i != -1) {
            int end;
            int begin = i + 2;
            int bracketIndex = pattern.indexOf(125, begin);
            int columnIndex = pattern.indexOf(58, begin);
            if (bracketIndex != -1 && columnIndex == -1) {
                end = bracketIndex;
            } else if (columnIndex != -1 && bracketIndex == -1) {
                end = columnIndex;
            } else if (bracketIndex != -1 && columnIndex != -1) {
                end = Math.min(bracketIndex, columnIndex);
            } else {
                throw new IllegalArgumentException("pattern [" + pattern + "] has an invalid syntax");
            }
            String otherPatternName = pattern.substring(begin, end);
            path.add(otherPatternName);
            String otherPattern = bank.get(otherPatternName);
            if (otherPattern == null) {
                throw new IllegalArgumentException("pattern [" + patternName + "] is referencing a non-existent pattern [" + otherPatternName + "]");
            }
            PatternBank.innerForbidCircularReferences(bank, patternName, path, otherPattern);
            i = pattern.indexOf("%{", i + 1);
        }
    }

    private static boolean patternReferencesItself(String pattern, String patternName) {
        return pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":");
    }
}

