/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.wire.PatchTxn;
import org.apache.jena.riot.thrift.wire.Patch_Data_Add;
import org.apache.jena.riot.thrift.wire.Patch_Data_Del;
import org.apache.jena.riot.thrift.wire.Patch_Header;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Add;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Del;
import org.apache.jena.riot.thrift.wire.RDF_BNode;
import org.apache.jena.riot.thrift.wire.RDF_IRI;
import org.apache.jena.riot.thrift.wire.RDF_Literal;
import org.apache.jena.riot.thrift.wire.RDF_Patch_Row;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_Triple;
import org.apache.jena.riot.thrift.wire.RDF_VAR;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RDFChangesWriterBinary
implements RDFChanges {
    private final RDF_Term tv = new RDF_Term();
    private final RDF_Term ts = new RDF_Term();
    private final RDF_Term tp = new RDF_Term();
    private final RDF_Term to = new RDF_Term();
    private final RDF_Term tg = new RDF_Term();
    private final Patch_Header header = new Patch_Header();
    private final Patch_Data_Add dataAdd = new Patch_Data_Add();
    private final Patch_Data_Del dataDel = new Patch_Data_Del();
    private final Patch_Prefix_Add prefixAdd = new Patch_Prefix_Add();
    private final Patch_Prefix_Del prefixDel = new Patch_Prefix_Del();
    private final RDF_Patch_Row row = new RDF_Patch_Row();
    private final TProtocol protocol;

    public static void write(RDFPatch patch, String filename) {
        try (OutputStream out = IO.openOutputFile((String)filename);){
            RDFChangesWriterBinary.write(patch, out);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    public static void write(RDFPatch patch, OutputStream out) {
        RDFChangesWriterBinary.writeBinary(out, c -> patch.apply((RDFChanges)c));
    }

    public static void writeBinary(OutputStream out, Consumer<RDFChanges> action) {
        TProtocol protocol = TRDF.protocol((OutputStream)out);
        RDFChangesWriterBinary writer = new RDFChangesWriterBinary(protocol);
        writer.start();
        action.accept(writer);
        writer.finish();
    }

    private static RDFChanges writerBinary(OutputStream out) {
        TProtocol protocol = TRDF.protocol((OutputStream)out);
        RDFChangesWriterBinary writer = new RDFChangesWriterBinary(protocol);
        return writer;
    }

    public RDFChangesWriterBinary(TProtocol protocol) {
        this.protocol = protocol;
    }

    private void write() {
        try {
            this.row.write(this.protocol);
        }
        catch (TException e) {
            throw new PatchException("Thrift exception", e);
        }
        this.row.clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        TRDF.flush((TProtocol)this.protocol);
    }

    @Override
    public void header(String field, Node value) {
        this.header.clear();
        this.tv.clear();
        this.header.setName(field);
        RDFChangesWriterBinary.toThrift(value, this.tv);
        this.header.setValue(this.tv);
        this.row.setHeader(this.header);
        this.write();
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.dataAdd.clear();
        this.set(g, s, p, o);
        this.dataAdd.setS(this.ts);
        this.dataAdd.setP(this.tp);
        this.dataAdd.setO(this.to);
        if (g != null) {
            this.dataAdd.setG(this.tg);
        }
        this.row.setDataAdd(this.dataAdd);
        this.write();
    }

    private void set(Node g, Node s, Node p, Node o) {
        this.ts.clear();
        RDFChangesWriterBinary.toThrift(s, this.ts);
        this.tp.clear();
        RDFChangesWriterBinary.toThrift(p, this.tp);
        this.to.clear();
        RDFChangesWriterBinary.toThrift(o, this.to);
        this.tg.clear();
        if (g != null) {
            RDFChangesWriterBinary.toThrift(g, this.tg);
        }
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.dataDel.clear();
        this.set(g, s, p, o);
        this.dataDel.setS(this.ts);
        this.dataDel.setP(this.tp);
        this.dataDel.setO(this.to);
        if (g != null) {
            this.dataDel.setG(this.tg);
        }
        this.row.setDataDel(this.dataDel);
        this.write();
    }

    @Override
    public void addPrefix(Node gn, String prefix, String uriStr) {
        this.prefixAdd.clear();
        if (gn != null) {
            this.tv.clear();
            RDFChangesWriterBinary.toThrift(gn, this.tv);
            this.prefixAdd.setGraphNode(this.tv);
        }
        this.prefixAdd.setPrefix(prefix);
        this.prefixAdd.setIriStr(uriStr);
        this.row.setPrefixAdd(this.prefixAdd);
        this.write();
    }

    @Override
    public void deletePrefix(Node gn, String prefix) {
        this.prefixDel.clear();
        if (gn != null) {
            this.tv.clear();
            RDFChangesWriterBinary.toThrift(gn, this.tv);
            this.prefixDel.setGraphNode(this.tv);
        }
        this.prefixDel.setPrefix(prefix);
        this.row.setPrefixDel(this.prefixDel);
        this.write();
    }

    @Override
    public void txnBegin() {
        this.row.setTxn(PatchTxn.TX);
        this.write();
    }

    @Override
    public void txnCommit() {
        this.row.setTxn(PatchTxn.TC);
        this.write();
    }

    @Override
    public void txnAbort() {
        this.row.setTxn(PatchTxn.TA);
        this.write();
    }

    @Override
    public void segment() {
        this.row.setTxn(PatchTxn.Segment);
        this.write();
    }

    static void toThrift(Node node, RDF_Term term) {
        if (node.isURI()) {
            RDF_IRI iri = new RDF_IRI(node.getURI());
            term.setIri(iri);
            return;
        }
        if (node.isBlank()) {
            RDF_BNode b = new RDF_BNode(node.getBlankNodeLabel());
            term.setBnode(b);
            return;
        }
        if (node.isURI()) {
            RDF_IRI iri = new RDF_IRI(node.getURI());
            term.setIri(iri);
            return;
        }
        if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String dt = node.getLiteralDatatypeURI();
            String lang = node.getLiteralLanguage();
            RDF_Literal literal = new RDF_Literal(lex);
            if (JenaRuntime.isRDF11 && (node.getLiteralDatatype().equals(XSDDatatype.XSDstring) || node.getLiteralDatatype().equals(RDFLangString.rdfLangString))) {
                dt = null;
            }
            if (dt != null) {
                literal.setDatatype(dt);
            }
            if (lang != null && !lang.isEmpty()) {
                literal.setLangtag(lang);
            }
            term.setLiteral(literal);
            return;
        }
        if (node.isVariable()) {
            RDF_VAR var = new RDF_VAR(node.getName());
            term.setVariable(var);
            return;
        }
        if (node.isNodeTriple()) {
            Triple triple = node.getTriple();
            RDF_Term sTerm = new RDF_Term();
            RDFChangesWriterBinary.toThrift(triple.getSubject(), sTerm);
            RDF_Term pTerm = new RDF_Term();
            RDFChangesWriterBinary.toThrift(triple.getPredicate(), pTerm);
            RDF_Term oTerm = new RDF_Term();
            RDFChangesWriterBinary.toThrift(triple.getObject(), oTerm);
            RDF_Triple tripleTerm = new RDF_Triple(sTerm, pTerm, oTerm);
            term.setTripleTerm(tripleTerm);
            return;
        }
        throw new PatchException("Node converstion not supported: " + node);
    }
}

