/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.support;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;

public class ContextPropagatingCallable<T>
implements Callable<T>,
Runnable {
    private final String correlationId;
    private final Callable<T> decorated;

    public ContextPropagatingCallable(Callable<T> decorated) {
        Validate.notNull(decorated);
        this.decorated = decorated;
        this.correlationId = Context.getCorrelationId();
    }

    public static <T> Callable<T> decorate(final Callable<T> callable) {
        Validate.notNull(callable);
        return new ContextPropagatingCallable<T>(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return callable.call();
            }
        });
    }

    public static Runnable decorate(final Runnable runnable) {
        Validate.notNull((Object)runnable);
        return new ContextPropagatingCallable<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap(e);
        }
    }

    @Override
    public T call() throws Exception {
        Context.setCorrelationId(this.correlationId);
        try {
            T t = this.decorated.call();
            return t;
        }
        finally {
            Context.unsetCorrelationId();
        }
    }
}

