/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.osm;

import org.geotools.tile.TileFactory;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.impl.WebMercatorTileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.osm.OSMTileFactory;
import org.geotools.tile.impl.osm.OSMTileIdentifier;

public class OSMService
extends WebMercatorTileService {
    private static final TileFactory tileFactory = new OSMTileFactory();
    private static double[] scaleList = new double[]{Double.NaN, Double.NaN, 1.47914381E8, 7.395719E7, 3.6978595E7, 1.8489297E7, 9244648.0, 4622324.0, 2311162.0, 1155581.0, 577790.0, 288895.0, 144447.0, 72223.0, 36111.0, 18055.0, 9027.0, 4513.0, 2256.0, 1128.0, 564.0, 282.0, 141.0, 70.0};

    public OSMService(String name, String baseUrl) {
        super(name, baseUrl);
    }

    @Override
    public double[] getScaleList() {
        return scaleList;
    }

    @Override
    public TileFactory getTileFactory() {
        return tileFactory;
    }

    @Override
    public TileIdentifier identifyTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel) {
        lat = TileFactory.normalizeDegreeValue(lat, 90);
        lon = TileFactory.normalizeDegreeValue(lon, 180);
        lat = OSMTileFactory.moveInRange(lat, -85.05112878, 85.05112878);
        int zoomPower = 1 << zoomLevel.getZoomLevel();
        int xTile = (int)Math.floor((lon + 180.0) / 360.0 * (double)zoomPower);
        double latr = lat * Math.PI / 180.0;
        double yd = (1.0 - Math.log(Math.tan(latr) + 1.0 / Math.cos(latr)) / Math.PI) / 2.0 * (double)zoomPower;
        int yTile = (int)Math.floor(yd);
        if (yTile < 0) {
            yTile = 0;
        }
        return new OSMTileIdentifier(xTile, yTile, zoomLevel, this.getName());
    }
}

