/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public class ResourceRestriction
extends Restriction {
    Set resources = new HashSet();

    public ResourceRestriction(int id, int type, String name, String descr) {
        super(id, type, name, descr);
    }

    public Set getResources() {
        return this.resources;
    }

    public void setResources(Set resources) throws NullParameterException {
        if (null == resources) {
            throw new NullParameterException("[resources] should not be [null].");
        }
        this.resources = resources;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by literals] map should not be [null].");
        }
        ArrayList list = super.toSql(idByLiteral, idByRes);
        ArrayList resourcez = new ArrayList(this.resources);
        for (int ri = 0; ri < resourcez.size(); ++ri) {
            Resource res = null;
            res = (Resource)resourcez.get(ri);
            Integer i = (Integer)idByRes.get(res);
            if (i == null && (i = (Integer)idByLiteral.get(res)) == null) {
                throw new SecurityException("Id not found for resource/literal : \n" + res);
            }
            int rid = i;
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO ");
            query.append("res_propr_restrs");
            query.append(" VALUES ");
            query.append("(").append(this.id);
            query.append(",");
            query.append(rid).append(");");
            list.add(query.toString());
        }
        return list;
    }
}

