/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryOptimizer;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sail.util.SailChangedEventImpl;
import org.openrdf.sesame.sailimpl.nativerdf.NamespaceStore;
import org.openrdf.sesame.sailimpl.nativerdf.NativeStatementIterator;
import org.openrdf.sesame.sailimpl.nativerdf.TripleStore;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStore;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeBNode;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeLiteral;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeURI;
import org.openrdf.util.log.ThreadLog;

public class NativeRdfRepository
implements RdfRepository {
    public static final String DATA_DIR_KEY = "dir";
    public static final String TRIPLES_INDEXES_KEY = "triple-indexes";
    private File _dataDir;
    private TripleStore _tripleStore;
    private ValueStore _valueStore;
    private NamespaceStore _namespaceStore;
    private ValueFactory _valueFactory;
    protected List _sailChangedListeners = new ArrayList(0);
    protected boolean _transactionStarted = false;
    protected SailChangedEventImpl _sailChangedEvent;

    public void initialize(Map configParams) throws SailInitializationException {
        String dir = (String)configParams.get(DATA_DIR_KEY);
        if (dir == null) {
            throw new SailInitializationException("Missing parameter: dir");
        }
        String tripleIndexes = (String)configParams.get(TRIPLES_INDEXES_KEY);
        this.initialize(new File(dir), tripleIndexes);
    }

    public void initialize(File dataDir) throws SailInitializationException {
        this.initialize(dataDir, null);
    }

    public void initialize(File dataDir, String tripleIndexes) throws SailInitializationException {
        ThreadLog.trace((String)"Initializing native RDF repository...");
        this._dataDir = dataDir;
        if (!this._dataDir.exists()) {
            boolean success = this._dataDir.mkdirs();
            if (!success) {
                throw new SailInitializationException("Unable to create data directory: " + dataDir);
            }
        } else {
            if (!this._dataDir.isDirectory()) {
                throw new SailInitializationException("The specified path does not denote a directory: " + dataDir);
            }
            if (!this._dataDir.canRead()) {
                throw new SailInitializationException("Not allowed to read from the specified directory: " + dataDir);
            }
            if (!this._dataDir.canWrite()) {
                throw new SailInitializationException("Not allowed to write to the specified directory: " + dataDir);
            }
        }
        try {
            this._namespaceStore = new NamespaceStore(this._dataDir);
            this._valueStore = new ValueStore(this._dataDir, this._namespaceStore, this);
            this._valueFactory = this._valueStore;
            this._tripleStore = new TripleStore(this._dataDir, tripleIndexes);
        }
        catch (IOException e) {
            throw new SailInitializationException(e);
        }
        ThreadLog.trace((String)"native RDF repository initialized");
    }

    public void shutDown() {
        try {
            this._tripleStore.close();
            this._valueStore.close();
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
    }

    public ValueFactory getValueFactory() {
        return this._valueFactory;
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        try {
            int subjID = 0;
            if (subj != null && (subjID = this._valueStore.getID((Value)subj)) == 0) {
                return new EmptyStatementIterator();
            }
            int predID = 0;
            if (pred != null && (predID = this._valueStore.getID((Value)pred)) == 0) {
                return new EmptyStatementIterator();
            }
            int objID = 0;
            if (obj != null && (objID = this._valueStore.getID(obj)) == 0) {
                return new EmptyStatementIterator();
            }
            return new NativeStatementIterator(this._tripleStore, this._valueStore, this._valueFactory, subj, pred, obj, subjID, predID, objID);
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        StatementIterator stIter = this.getStatements(subj, pred, obj);
        boolean result = stIter.hasNext();
        stIter.close();
        return result;
    }

    public Query optimizeQuery(Query qc) {
        QueryOptimizer.optimizeQuery(qc);
        this._replaceValuesInQuery(qc);
        return qc;
    }

    private void _replaceValuesInQuery(Query query) {
        ArrayList varList = new ArrayList();
        query.getVariables(varList);
        for (int i = 0; i < varList.size(); ++i) {
            Var var = (Var)varList.get(i);
            if (!var.hasValue()) continue;
            Value value = var.getValue();
            if (value instanceof URI) {
                var.setValue(new NativeURI(this, (URI)value));
                continue;
            }
            if (value instanceof BNode) {
                var.setValue(new NativeBNode(this, (BNode)value));
                continue;
            }
            if (!(value instanceof Literal)) continue;
            Object lit = (Literal)value;
            lit = lit.getLanguage() != null ? new NativeLiteral(this, lit.getLabel(), lit.getLanguage()) : (lit.getDatatype() != null ? new NativeLiteral(this, lit.getLabel(), lit.getDatatype()) : new NativeLiteral(this, lit.getLabel()));
            var.setValue((Value)lit);
        }
    }

    public NamespaceIterator getNamespaces() {
        return this._namespaceStore.getNamespaces();
    }

    public void startTransaction() {
        try {
            this._valueStore.startTransaction();
            this._tripleStore.startTransaction();
            this._transactionStarted = true;
            this._sailChangedEvent = new SailChangedEventImpl();
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
    }

    public void commitTransaction() {
        try {
            this._tripleStore.commitTransaction();
            this._valueStore.commitTransaction();
            this._notifySailChanged(this._sailChangedEvent);
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
        finally {
            this._sailChangedEvent = null;
            this._transactionStarted = false;
        }
    }

    public boolean transactionStarted() {
        return this._transactionStarted;
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        try {
            int subjID = this._valueStore.storeValue((Value)subj);
            int predID = this._valueStore.storeValue((Value)pred);
            int objID = this._valueStore.storeValue(obj);
            byte[] oldValue = this._tripleStore.storeTriple(subjID, predID, objID);
            if (oldValue == null) {
                this._sailChangedEvent.setStatementsAdded(true);
            }
        }
        catch (IOException e) {
            throw new SailUpdateException(e);
        }
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        try {
            int subjID = 0;
            if (subj != null && (subjID = this._valueStore.getID((Value)subj)) == 0) {
                return 0;
            }
            int predID = 0;
            if (pred != null && (predID = this._valueStore.getID((Value)pred)) == 0) {
                return 0;
            }
            int objID = 0;
            if (obj != null && (objID = this._valueStore.getID(obj)) == 0) {
                return 0;
            }
            int count = this._tripleStore.removeTriples(subjID, predID, objID);
            if (count > 0) {
                this._sailChangedEvent.setStatementsRemoved(true);
            }
            return count;
        }
        catch (IOException e) {
            throw new SailUpdateException(e);
        }
    }

    public void clearRepository() throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        try {
            this._tripleStore.clear();
            this._valueStore.clear();
            this._sailChangedEvent.setStatementsRemoved(true);
        }
        catch (IOException e) {
            throw new SailUpdateException(e);
        }
    }

    public void changeNamespacePrefix(String namespace, String prefix) {
        this._namespaceStore.setNamespacePrefix(prefix, namespace);
    }

    public static void main(String[] args) throws Exception {
        File dataDir = new File(args[0]);
        File rdfFile = new File(args[1]);
        String baseURI = "foo:bar";
        if (args.length >= 3) {
            baseURI = args[2];
        }
        final NativeRdfRepository repository = new NativeRdfRepository();
        repository.initialize(dataDir);
        RdfXmlParser parser = new RdfXmlParser(repository.getValueFactory());
        parser.setDatatypeHandling(10);
        FileInputStream inputStream = new FileInputStream(rdfFile);
        parser.setStatementHandler(new StatementHandler(){

            public void handleStatement(Resource subj, URI pred, Value obj) throws StatementHandlerException {
                try {
                    repository.addStatement(subj, pred, obj);
                }
                catch (SailUpdateException e) {
                    throw new StatementHandlerException((Exception)e);
                }
            }
        });
        long startTime = System.currentTimeMillis();
        repository.startTransaction();
        parser.parse((InputStream)inputStream, baseURI);
        repository.commitTransaction();
        long endTime = System.currentTimeMillis();
        ((InputStream)inputStream).close();
        System.out.println("Upload completed in " + (endTime - startTime) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SailChangedListener listener) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            this._sailChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SailChangedListener listener) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            this._sailChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _notifySailChanged(SailChangedEventImpl event) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            if (this._sailChangedListeners != null && event.sailChanged()) {
                Iterator listeners = this._sailChangedListeners.iterator();
                while (listeners.hasNext()) {
                    SailChangedListener listener = (SailChangedListener)listeners.next();
                    listener.sailChanged(event);
                }
            }
        }
    }
}

