/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

public class Projection
implements Value {
    protected Value[] _values;
    protected int _position;
    protected int _size;

    public Projection(int size) {
        this._values = new Value[size];
        this._position = 0;
        this._size = size;
    }

    public void add(Value val) throws IndexOutOfBoundsException {
        this._values[this._position] = val;
        ++this._position;
    }

    public Value get(int position) throws IndexOutOfBoundsException {
        return this._values[position];
    }

    public int size() {
        return this._size;
    }

    public boolean equals(Object other) {
        Projection oProj;
        if (this == other) {
            return true;
        }
        if (other instanceof Projection && this._size == (oProj = (Projection)other).size()) {
            for (int i = 0; i < this._size; ++i) {
                Value oVal = oProj.get(i);
                if (!(this._values[i] != null ? !this._values[i].equals(oVal) : oVal != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this._values.length > 0 && this._values[0] != null) {
            return this._values[0].hashCode();
        }
        return 42;
    }

    public int compareTo(Object o) {
        Projection other = (Projection)o;
        int result = this.size() - other.size();
        if (result == 0) {
            for (int i = 0; i < this.size() && result == 0; ++i) {
                Value thisValue = this.get(i);
                Value otherValue = other.get(i);
                result = thisValue.compareTo((Object)otherValue);
            }
        }
        return result;
    }

    public StatementIterator getObjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }
}

