/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public abstract class PreparedStatementSQLDialect
extends SQLDialect {
    protected PreparedStatementSQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void prepareGeometryValue(Class<? extends Geometry> gClass, int dimension, int srid, Class binding, StringBuffer sql) {
        sql.append("?");
    }

    public final void prepareGeometryValue(Geometry g, int dimension, int srid, Class binding, StringBuffer sql) {
        this.prepareGeometryValue(g == null ? null : g.getClass(), dimension, srid, binding, sql);
    }

    public void prepareFunctionArgument(Class clazz, StringBuffer sql) {
        sql.append("?");
    }

    public abstract void setGeometryValue(Geometry var1, int var2, int var3, Class var4, PreparedStatement var5, int var6) throws SQLException;

    public void setValue(Object value, Class<?> binding, AttributeDescriptor att, PreparedStatement ps, int column, Connection cx) throws SQLException {
        Integer sqlType = this.dataStore.getMapping(binding, att);
        if (value == null) {
            ps.setNull(column, sqlType);
            return;
        }
        switch (sqlType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                ps.setString(column, this.convert(value, String.class));
                break;
            }
            case -7: 
            case 16: {
                ps.setBoolean(column, this.convert(value, Boolean.class));
                break;
            }
            case -6: 
            case 5: {
                ps.setShort(column, this.convert(value, Short.class));
                break;
            }
            case 4: {
                ps.setInt(column, this.convert(value, Integer.class));
                break;
            }
            case -5: {
                ps.setLong(column, this.convert(value, Long.class));
                break;
            }
            case 6: 
            case 7: {
                ps.setFloat(column, this.convert(value, Float.class).floatValue());
                break;
            }
            case 8: {
                ps.setDouble(column, this.convert(value, Double.class));
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(column, this.convert(value, BigDecimal.class));
                break;
            }
            case 91: {
                ps.setDate(column, this.convert(value, Date.class));
                break;
            }
            case 92: {
                ps.setTime(column, this.convert(value, Time.class));
                break;
            }
            case 93: {
                ps.setTimestamp(column, this.convert(value, Timestamp.class));
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                ps.setBytes(column, this.convert(value, byte[].class));
                break;
            }
            case 2005: {
                String string = this.convert(value, String.class);
                ps.setCharacterStream(column, (Reader)new StringReader(string), string.length());
                break;
            }
            default: {
                ps.setObject(column, value, 1111);
            }
        }
    }

    public void setArrayValue(Object value, AttributeDescriptor att, PreparedStatement ps, int i, Connection cx) throws SQLException {
        if (value == null) {
            ps.setNull(i, 2003);
        } else {
            String typeName = this.getArrayComponentTypeName(att);
            Class<String> componentType = typeName != null ? this.dataStore.getSqlTypeNameToClassMappings().get(typeName) : String.class;
            java.sql.Array array = this.convertToArray(value, typeName, componentType, cx);
            ps.setArray(i, array);
        }
    }

    protected String getArrayComponentTypeName(AttributeDescriptor att) throws SQLException {
        Map<String, Class<?>> mappings = this.dataStore.getSqlTypeNameToClassMappings();
        Class<?> componentType = att.getType().getBinding().getComponentType();
        List sqlTypeNames = mappings.entrySet().stream().filter(e -> ((Class)e.getValue()).equals(componentType)).map(e -> (String)e.getKey()).collect(Collectors.toList());
        if (sqlTypeNames.isEmpty()) {
            throw new SQLException("Failed to find a SQL type for " + componentType);
        }
        if (sqlTypeNames.size() > 1) {
            throw new SQLException(String.format("Found multiple SQL type candidates %s for the Java type %s", sqlTypeNames, componentType.getName()));
        }
        return (String)sqlTypeNames.get(0);
    }

    protected java.sql.Array convertToArray(Object value, String componentTypeName, Class componentType, Connection connection) throws SQLException {
        int length = Array.getLength(value);
        Object[] elements = new Object[length];
        for (int i = 0; i < elements.length; ++i) {
            Object converted;
            Object element = Array.get(value, i);
            elements[i] = element == null ? null : (converted = this.convertArrayElement(element, componentType));
        }
        return connection.createArrayOf(componentTypeName, elements);
    }

    protected Object convertArrayElement(Object value, Class<?> target) throws SQLException {
        Object converted = Converters.convert((Object)value, target);
        if (converted == null) {
            String message = String.format("Failed to convert array element %s to target type %s", value, target);
            throw new SQLException(message);
        }
        return converted;
    }

    protected <T> T convert(Object value, Class<T> binding) {
        if (value == null) {
            return null;
        }
        if (!binding.isInstance(value)) {
            Object converted = Converters.convert((Object)value, binding);
            if (converted != null) {
                value = converted;
            } else {
                this.dataStore.getLogger().warning("Unable to convert " + value + " to " + binding.getName());
            }
        }
        return binding.cast(value);
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        PreparedFilterToSQL f2s = new PreparedFilterToSQL(this);
        f2s.setCapabilities(BASE_DBMS_CAPABILITIES);
        return f2s;
    }

    public void onSelect(PreparedStatement select, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onDelete(PreparedStatement delete, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onInsert(PreparedStatement insert, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onUpdate(PreparedStatement update, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }
}

