/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import org.geotools.api.data.FeatureEvent;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCInsertFeatureWriter;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.JDBCUpdateFeatureWriter;
import org.geotools.jdbc.JDBCUpdateInsertFeatureWriter;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;

public final class JDBCFeatureStore
extends ContentFeatureStore {
    public JDBCFeatureSource delegate;

    public JDBCFeatureStore(ContentEntry entry, Query query) throws IOException {
        super(entry, query);
        this.delegate = new JDBCFeatureSource(entry, query){

            @Override
            public void setTransaction(Transaction transaction) {
                super.setTransaction(transaction);
                JDBCFeatureStore.this.setTransaction(transaction);
            }
        };
        HashSet<Hints.Key> jdbcHints = new HashSet<Hints.Key>();
        jdbcHints.addAll(this.delegate.getSupportedHints());
        this.getDataStore().getSQLDialect().addSupportedHints(jdbcHints);
        this.hints = Collections.unmodifiableSet(jdbcHints);
    }

    @Override
    protected boolean canEvent() {
        return true;
    }

    @Override
    public JDBCDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public JDBCFeatureSource getFeatureSource() {
        return this.delegate;
    }

    @Override
    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    @Override
    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public Name getName() {
        return this.delegate.getName();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    @Override
    public JDBCState getState() {
        return this.delegate.getState();
    }

    @Override
    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    public PrimaryKey getPrimaryKey() {
        return this.delegate.getPrimaryKey();
    }

    public void setExposePrimaryKeyColumns(boolean exposePrimaryKeyColumns) {
        this.delegate.setExposePrimaryKeyColumns(exposePrimaryKeyColumns);
    }

    public boolean isExposePrimaryKeyColumns() {
        return this.delegate.isExposePrimaryKeyColumns();
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCount(query);
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    @Override
    protected boolean canFilter(Query query) {
        return this.delegate.canFilter(query);
    }

    @Override
    protected boolean canSort(Query query) {
        return this.delegate.canSort(query);
    }

    @Override
    protected boolean canRetype(Query query) {
        return this.delegate.canRetype(query);
    }

    @Override
    protected boolean canLimit(Query query) {
        return this.delegate.canLimit(query);
    }

    @Override
    protected boolean canOffset(Query query) {
        return this.delegate.canOffset(query);
    }

    @Override
    protected boolean canTransact() {
        return this.delegate.canTransact();
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        Filter postFilter;
        if (flags == 0) {
            throw new IllegalArgumentException("no write flags set");
        }
        Connection cx = this.getDataStore().getConnection(this.getState());
        try {
            if ((flags | 1) == 1) {
                Query queryNone = new Query(query);
                queryNone.setFilter((Filter)Filter.EXCLUDE);
                if (this.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
                    PreparedStatement ps = this.getDataStore().selectSQLPS(this.getSchema(), queryNone, cx);
                    return new JDBCInsertFeatureWriter(ps, cx, this.delegate, query);
                }
                String sql = this.getDataStore().selectSQL(this.getSchema(), queryNone);
                this.getDataStore().getLogger().fine(sql);
                return new JDBCInsertFeatureWriter(sql, cx, this.delegate, query);
            }
            Filter[] split = this.delegate.splitFilter(query.getFilter());
            Filter preFilter = split[0];
            postFilter = split[1];
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            if (this.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
                PreparedStatement ps = this.getDataStore().selectSQLPS(this.getSchema(), preQuery, cx);
                writer = (flags | 2) == 2 ? new JDBCUpdateFeatureWriter(ps, cx, this.delegate, query) : new JDBCUpdateInsertFeatureWriter(ps, cx, this.delegate, query.getPropertyNames(), query);
            } else {
                String sql = this.getDataStore().selectSQL(this.getSchema(), preQuery);
                this.getDataStore().getLogger().fine(sql);
                writer = (flags | 2) == 2 ? new JDBCUpdateFeatureWriter(sql, cx, this.delegate, query) : new JDBCUpdateInsertFeatureWriter(sql, cx, this.delegate, query);
            }
        }
        catch (Throwable e) {
            this.getDataStore().closeSafe(cx);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter(writer, postFilter);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyFeatures(Name[] names, Object[] values, Filter filter) throws IOException {
        AttributeDescriptor[] innerTypes = new AttributeDescriptor[names.length];
        for (int i = 0; i < names.length; ++i) {
            innerTypes[i] = this.getSchema().getDescriptor(names[i].getLocalPart());
            if (innerTypes[i] != null) continue;
            throw new IllegalArgumentException("Unknown attribute " + names[i].getLocalPart());
        }
        Filter[] splitted = this.delegate.splitFilter(filter);
        Filter preFilter = splitted[0];
        Filter postFilter = splitted[1];
        if (postFilter != null && !Filter.INCLUDE.equals(postFilter)) {
            super.modifyFeatures(names, values, filter);
        } else {
            Connection cx = null;
            Transaction tx = this.getState().getTransaction();
            try {
                ReferencedEnvelope before;
                cx = this.getDataStore().getConnection(tx);
                SimpleFeatureType featureType = this.getSchema();
                try {
                    this.getDataStore().ensureAuthorization(featureType, preFilter, this.getTransaction(), cx);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                ContentState state = this.getEntry().getState(this.transaction);
                ReferencedEnvelope bounds = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
                if (state.hasListener() && (before = this.getBounds(new Query(this.getSchema().getTypeName(), preFilter))) != null && !before.isEmpty()) {
                    bounds = before;
                }
                try {
                    this.getDataStore().update(this.getSchema(), innerTypes, values, preFilter, cx);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
                if (state.hasListener()) {
                    for (Object value : values) {
                        if (!(value instanceof Geometry)) continue;
                        Geometry geometry = (Geometry)value;
                        bounds.expandToInclude(geometry.getEnvelopeInternal());
                    }
                    FeatureEvent event = new FeatureEvent(this, FeatureEvent.Type.CHANGED, bounds, preFilter);
                    state.fireFeatureEvent(event);
                }
            }
            finally {
                if (tx == null || tx == Transaction.AUTO_COMMIT) {
                    this.getDataStore().closeSafe(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeatures(Filter filter) throws IOException {
        Filter[] splitted = this.delegate.splitFilter(filter);
        Filter preFilter = splitted[0];
        Filter postFilter = splitted[1];
        if (postFilter != null && !Filter.INCLUDE.equals(postFilter)) {
            super.removeFeatures(filter);
        } else {
            Transaction tx = this.getState().getTransaction();
            Connection cx = null;
            try {
                ReferencedEnvelope before;
                cx = this.getDataStore().getConnection(tx);
                SimpleFeatureType featureType = this.getSchema();
                try {
                    this.getDataStore().ensureAuthorization(featureType, preFilter, this.getTransaction(), cx);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                ContentState state = this.getEntry().getState(this.transaction);
                ReferencedEnvelope bounds = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
                if (state.hasListener() && (before = this.getBounds(new Query(this.getSchema().getTypeName(), preFilter))) != null && !before.isEmpty()) {
                    bounds = before;
                }
                this.getDataStore().delete(featureType, preFilter, cx);
                if (state.hasListener()) {
                    FeatureEvent event = new FeatureEvent(this, FeatureEvent.Type.REMOVED, bounds, preFilter);
                    state.fireFeatureEvent(event);
                }
            }
            finally {
                if (tx == null || tx == Transaction.AUTO_COMMIT) {
                    this.getDataStore().closeSafe(cx);
                }
            }
        }
    }
}

