/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.requests;

import java.util.ArrayList;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.TypeName;
import org.fao.geonet.csw.common.requests.CatalogRequest;
import org.jdom.Content;
import org.jdom.Element;

public class DescribeRecordRequest
extends CatalogRequest {
    private String outputFormat;
    private String schemaLang;
    private List<TypeName> alTypeNames = new ArrayList<TypeName>();

    public DescribeRecordRequest(ServiceContext context) {
        super(context);
    }

    public void addTypeName(TypeName name) {
        this.alTypeNames.add(name);
    }

    public void setOutputFormat(String format) {
        this.outputFormat = format;
    }

    public void setSchemaLanguage(String language) {
        this.schemaLang = language;
    }

    @Override
    protected String getRequestName() {
        return "DescribeRecord";
    }

    @Override
    protected void setupGetParams() {
        this.addParam("request", this.getRequestName());
        this.addParam("service", "CSW");
        this.addParam("version", this.getServerVersion());
        if (this.outputFormat != null) {
            this.addParam("outputFormat", this.outputFormat);
        }
        if (this.schemaLang != null) {
            this.addParam("schemaLanguage", this.schemaLang);
        }
        this.fill("typeName", this.alTypeNames, Csw.NAMESPACE_CSW.getPrefix() + ":");
        this.addParam("namespace", Csw.NAMESPACE_CSW.getPrefix() + ":" + Csw.NAMESPACE_CSW.getURI());
    }

    @Override
    protected Element getPostParams() {
        Element params = new Element(this.getRequestName(), Csw.NAMESPACE_CSW);
        params.setAttribute("service", "CSW");
        params.setAttribute("version", this.getServerVersion());
        if (this.outputFormat != null) {
            params.setAttribute("outputFormat", this.outputFormat);
        }
        if (this.schemaLang != null) {
            params.setAttribute("schemaLanguage", this.schemaLang);
        }
        for (TypeName typeName : this.alTypeNames) {
            Element el = new Element("TypeName", Csw.NAMESPACE_CSW);
            el.setText(typeName.toString());
            el.setAttribute("targetNamespace", Csw.NAMESPACE_CSW.getURI());
            params.addContent((Content)el);
        }
        return params;
    }
}

