/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.impl.ElementHandler;
import org.geotools.xsd.impl.NodeImpl;
import org.geotools.xsd.impl.ParserHandler;
import org.xml.sax.SAXException;

public class PullParser {
    PullParserHandler handler;
    XMLStreamReader pp;
    Attributes atts = new Attributes();

    public PullParser(Configuration config, InputStream input, QName element) {
        this(config, input, new ElementPullParserHandler(element, config));
    }

    public PullParser(Configuration config, InputStream input, Class type) {
        this(config, input, new TypePullParserHandler(type, config));
    }

    public PullParser(Configuration config, InputStream input, Object ... handlerSpecs) {
        this(config, input, new OrPullParserHandler(config, handlerSpecs));
    }

    public PullParser(Configuration config, InputStream input, PullParserHandler handler) {
        this.handler = handler;
        this.pp = this.createPullParser(input);
    }

    public void setContextCustomizer(ParserHandler.ContextCustomizer contextCustomizer) {
        this.handler.setContextCustomizer(contextCustomizer);
    }

    public void setStrict(boolean strict) {
        this.handler.setStrict(strict);
    }

    public void setURIHandler(URIHandler uriHandler) {
        this.handler.getURIHandlers().clear();
        this.handler.getURIHandlers().add(uriHandler);
    }

    public Object parse() throws XMLStreamException, IOException, SAXException {
        if (this.handler.getLogger() == null) {
            this.handler.startDocument();
        }
        while (this.pp.hasNext()) {
            int e = this.pp.next();
            switch (e) {
                case 1: {
                    int count = this.pp.getNamespaceCount();
                    for (int i = 0; i < count; ++i) {
                        String pre = this.pp.getNamespacePrefix(i);
                        this.handler.startPrefixMapping(pre != null ? pre : "", this.pp.getNamespaceURI(i));
                    }
                    this.handler.startElement(this.pp.getNamespaceURI(), this.pp.getLocalName(), this.str(this.pp.getName()), this.atts);
                    break;
                }
                case 4: {
                    char[] chars = this.pp.getTextCharacters();
                    this.handler.characters(chars, this.pp.getTextStart(), this.pp.getTextLength());
                    break;
                }
                case 2: {
                    this.handler.endElement(this.pp.getNamespaceURI(), this.pp.getLocalName(), this.str(this.pp.getName()));
                    int count = this.pp.getNamespaceCount();
                    for (int i = count - 1; i >= 0; --i) {
                        this.handler.endPrefixMapping(this.pp.getNamespacePrefix(i));
                    }
                    if (this.handler.getObject() == null) break;
                    return this.handler.getObject();
                }
                case 8: {
                    this.handler.endDocument();
                }
            }
        }
        return null;
    }

    QName qName(String prefix, String name, XMLStreamReader pp2) {
        if (prefix != null) {
            return new QName(this.pp.getNamespaceURI(prefix), name, prefix);
        }
        return new QName(name);
    }

    XMLStreamReader createPullParser(InputStream input) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        factory.setProperty("javax.xml.stream.isValidating", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        try {
            return factory.createXMLStreamReader(input);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error creating pull parser", e);
        }
    }

    String str(QName qName) {
        return qName.getPrefix() != null ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
    }

    static class OrPullParserHandler
    extends PullParserHandler {
        private final Collection<PullParserHandler> parserHandlers;

        public OrPullParserHandler(Configuration config, Object ... handlerSpecs) {
            super(config);
            ArrayList<PullParserHandler> handlers = new ArrayList<PullParserHandler>(handlerSpecs.length);
            for (Object spec : handlerSpecs) {
                if (spec instanceof Class) {
                    handlers.add(new TypePullParserHandler((Class)spec, config));
                    continue;
                }
                if (spec instanceof QName) {
                    handlers.add(new ElementIgnoringNamespacePullParserHandler((QName)spec, config));
                    continue;
                }
                if (spec instanceof PullParserHandler) {
                    handlers.add((PullParserHandler)spec);
                    continue;
                }
                throw new IllegalArgumentException("Unknown element: " + spec.toString() + " of type: " + spec.getClass());
            }
            this.parserHandlers = Collections.unmodifiableCollection(handlers);
        }

        @Override
        protected boolean stop(ElementHandler handler) {
            for (PullParserHandler pph : this.parserHandlers) {
                if (!pph.stop(handler)) continue;
                return true;
            }
            return false;
        }
    }

    static class ElementIgnoringNamespacePullParserHandler
    extends ElementPullParserHandler {
        public ElementIgnoringNamespacePullParserHandler(QName element, Configuration config) {
            super(element, config);
        }

        @Override
        protected boolean stop(ElementHandler handler) {
            return this.element.getLocalPart().equals(handler.getComponent().getName());
        }
    }

    static class ElementPullParserHandler
    extends PullParserHandler {
        QName element;

        public ElementPullParserHandler(QName element, Configuration config) {
            super(config);
            this.element = element;
        }

        @Override
        protected boolean stop(ElementHandler handler) {
            boolean equal = false;
            equal = this.element.getNamespaceURI() != null ? this.element.getNamespaceURI().equals(handler.getComponent().getNamespace()) : handler.getComponent().getNamespace() == null;
            return equal && this.element.getLocalPart().equals(handler.getComponent().getName());
        }
    }

    static class TypePullParserHandler
    extends PullParserHandler {
        Class type;

        public TypePullParserHandler(Class type, Configuration config) {
            super(config);
            this.type = type;
        }

        @Override
        protected boolean stop(ElementHandler handler) {
            return this.type.isInstance(handler.getParseNode().getValue());
        }
    }

    static abstract class PullParserHandler
    extends ParserHandler {
        PullParser parser;
        Object object;

        public PullParserHandler(Configuration config) {
            super(config);
        }

        @Override
        protected void endElementInternal(ElementHandler handler) {
            this.object = null;
            if (this.stop(handler)) {
                this.object = handler.getParseNode().getValue();
                if (handler.getParentHandler() instanceof ElementHandler) {
                    ElementHandler parent = (ElementHandler)handler.getParentHandler();
                    ((NodeImpl)parent.getParseNode()).removeChild(handler.getParseNode());
                }
            }
        }

        public Object getObject() {
            return this.object;
        }

        protected abstract boolean stop(ElementHandler var1);
    }

    class Attributes
    implements org.xml.sax.Attributes {
        Attributes() {
        }

        @Override
        public int getLength() {
            return PullParser.this.pp.getAttributeCount();
        }

        @Override
        public String getURI(int index) {
            return PullParser.this.pp.getAttributeNamespace(index);
        }

        @Override
        public String getLocalName(int index) {
            return PullParser.this.pp.getAttributeLocalName(index);
        }

        @Override
        public String getQName(int index) {
            String prefix = PullParser.this.pp.getAttributePrefix(index);
            if (prefix != null) {
                return prefix + ":" + PullParser.this.pp.getAttributeName(index);
            }
            return PullParser.this.str(PullParser.this.pp.getAttributeName(index));
        }

        @Override
        public String getType(int index) {
            return PullParser.this.pp.getAttributeType(index);
        }

        @Override
        public String getValue(int index) {
            return PullParser.this.pp.getAttributeValue(index);
        }

        @Override
        public int getIndex(String uri, String localName) {
            for (int i = 0; i < PullParser.this.pp.getAttributeCount(); ++i) {
                if (!PullParser.this.pp.getAttributeNamespace(i).equals(uri) || !PullParser.this.pp.getAttributeLocalName(i).equals(localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            for (int i = 0; i < PullParser.this.pp.getAttributeCount(); ++i) {
                if (!(PullParser.this.pp.getAttributePrefix(i) + ":" + PullParser.this.pp.getAttributeLocalName(i)).equals(qName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            for (int i = 0; i < PullParser.this.pp.getAttributeCount(); ++i) {
                if (!PullParser.this.pp.getAttributeNamespace(i).equals(uri) || !PullParser.this.pp.getAttributeLocalName(i).equals(localName)) continue;
                return PullParser.this.pp.getAttributeType(i);
            }
            return null;
        }

        @Override
        public String getType(String qName) {
            for (int i = 0; i < PullParser.this.pp.getAttributeCount(); ++i) {
                if (!(PullParser.this.pp.getAttributePrefix(i) + ":" + PullParser.this.pp.getAttributeName(i)).equals(qName)) continue;
                return PullParser.this.pp.getAttributeType(i);
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return PullParser.this.pp.getAttributeValue(uri, localName);
        }

        @Override
        public String getValue(String qName) {
            return PullParser.this.pp.getAttributeValue(null, qName);
        }
    }
}

