/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import javax.xml.transform.TransformerFactory;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Env;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.TransformerFactoryFactory;

public class SiteInformation {
    final Properties properties = System.getProperties();
    private Map<String, String> catProperties = new LinkedHashMap<String, String>();
    private Map<String, String> indexProperties = new LinkedHashMap<String, String>();
    private Map<String, String> systemProperties = new LinkedHashMap<String, String>();
    private Map<String, String> envProperties = new LinkedHashMap<String, String>();
    private Map<String, String> databaseProperties = new LinkedHashMap<String, String>();
    private Map<String, String> versionProperties = new LinkedHashMap<String, String>();

    public SiteInformation(ServiceContext context, GeonetContext gc) {
        if (context.getUserSession().isAuthenticated()) {
            this.loadCatalogueInfo(gc);
            try {
                this.loadDatabaseInfo(context);
            }
            catch (SQLException e) {
                Log.error((String)"geonetwork", (String)e.getMessage(), (Throwable)e);
            }
            try {
                this.loadIndexInfo(context);
            }
            catch (ElasticsearchException | IOException e) {
                Log.error((String)"geonetwork", (String)e.getMessage(), (Throwable)e);
            }
            this.loadEnvInfo();
            this.loadVersionInfo(context);
            this.loadSystemInfo();
        }
    }

    @JsonProperty(value="catalogue")
    public Map<String, String> getCatProperties() {
        return this.catProperties;
    }

    public void setCatProperties(Map<String, String> catProperties) {
        this.catProperties = catProperties;
    }

    @JsonProperty(value="index")
    public Map<String, String> getIndexProperties() {
        return this.indexProperties;
    }

    public void setIndexProperties(Map<String, String> indexProperties) {
        this.indexProperties = indexProperties;
    }

    @JsonProperty(value="main")
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @JsonProperty(value="env")
    public Map<String, String> getEnvProperties() {
        return this.envProperties;
    }

    public void setEnvProperties(Map<String, String> envProperties) {
        this.envProperties = envProperties;
    }

    @JsonProperty(value="database")
    public Map<String, String> getDatabaseProperties() {
        return this.databaseProperties;
    }

    public void setDatabaseProperties(Map<String, String> databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    @JsonProperty(value="version")
    public Map<String, String> getVersionProperties() {
        return this.versionProperties;
    }

    public void setVersionProperties(Map<String, String> versionProperties) {
        this.versionProperties = versionProperties;
    }

    private void loadCatalogueInfo(GeonetContext gc) {
        String[] props;
        ServiceConfig sc = (ServiceConfig)gc.getBean(ServiceConfig.class);
        for (String prop : props = new String[]{"geonetworkDataDir", "dataDir", "backupDir", "codeListDir", "resources", "schemaPluginsDir", "schemaPublicationDir", "configDir", "indexConfigDir", "formatterPath", "htmlCacheDir", "subversionPath"}) {
            this.catProperties.put("data." + prop, sc.getValue(prop));
        }
    }

    private void loadSystemInfo() {
        this.systemProperties.put("java.version", this.properties.getProperty("java.version"));
        this.systemProperties.put("java.vm.name", this.properties.getProperty("java.vm.name"));
        this.systemProperties.put("java.vm.vendor", this.properties.getProperty("java.vm.vendor"));
        this.systemProperties.put("os.name", this.properties.getProperty("os.name"));
        this.systemProperties.put("os.arch", this.properties.getProperty("os.arch"));
        try {
            TransformerFactory transFact = TransformerFactoryFactory.getTransformerFactory();
            this.systemProperties.put("xslt.factory", transFact.getClass().getName());
        }
        catch (Exception e) {
            this.systemProperties.put("xslt.factory", "Exception:" + e.getMessage());
        }
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totMem = Runtime.getRuntime().totalMemory() / 1024L;
        this.systemProperties.put("mem.free", "" + freeMem);
        this.systemProperties.put("mem.total", "" + totMem);
        HashSet<String> hostNames = new HashSet<String>();
        try {
            hostNames.add(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostNames.add(System.getenv("HOSTNAME"));
        hostNames.add(System.getenv("COMPUTERNAME"));
        this.systemProperties.put("host.name", hostNames.stream().filter(s -> s != null && !s.isBlank()).collect(Collectors.joining(", ")));
    }

    private void loadIndexInfo(ServiceContext context) throws IOException {
        EsSearchManager esSearchManager = (EsSearchManager)context.getBean(EsSearchManager.class);
        this.indexProperties.put("es.url", esSearchManager.getClient().getServerUrl());
        this.indexProperties.put("es.version", esSearchManager.getClient().getServerVersion());
        this.indexProperties.put("es.index", esSearchManager.getDefaultIndex());
    }

    private void loadEnvInfo() {
        String[] variables;
        for (String variable : variables = new String[]{"harvester.scheduler.enabled", "db.migration_onstartup"}) {
            String value = Env.getPropertyFromEnv((String)variable, (String)"");
            if (!StringUtils.isNotEmpty((String)value)) continue;
            this.envProperties.put(variable, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseInfo(ServiceContext context) throws SQLException {
        String dbURL = null;
        try (Connection connection = null;){
            connection = ((DataSource)context.getBean(DataSource.class)).getConnection();
            dbURL = connection.getMetaData().getURL();
            this.databaseProperties.put("db.openattempt", "Database Opened Successfully");
            try {
                this.databaseProperties.put("db.type", connection.getMetaData().getDatabaseProductName());
                this.databaseProperties.put("db.version", connection.getMetaData().getDatabaseProductVersion());
                this.databaseProperties.put("db.driver", connection.getMetaData().getDriverName());
                this.databaseProperties.put("db.driverVersion", connection.getMetaData().getDriverVersion());
                this.databaseProperties.put("db.username", connection.getMetaData().getUserName());
                this.databaseProperties.put("db.name", connection.getCatalog());
                this.databaseProperties.put("db.schema", connection.getSchema());
            }
            catch (AbstractMethodError e) {
                Log.warning((String)"geonetwork", (Object)("Failed to get db properties. " + e.getMessage()));
            }
            if (connection instanceof BasicDataSource) {
                BasicDataSource basicDataSource = (BasicDataSource)connection;
                try {
                    this.databaseProperties.put("db.numactive", "" + basicDataSource.getNumActive());
                    this.databaseProperties.put("db.numidle", "" + basicDataSource.getNumIdle());
                    this.databaseProperties.put("db.maxactive", "" + basicDataSource.getMaxTotal());
                }
                catch (Exception e) {
                    this.databaseProperties.put("db.statserror", "Failed to get stats on database connections. Error is: " + e.getMessage());
                }
            }
        }
        this.databaseProperties.put("db.url", dbURL);
    }

    private void loadVersionInfo(ServiceContext context) {
        Properties prop = new Properties();
        try (InputStream input = this.getClass().getResourceAsStream("/git.properties");){
            SettingManager settingManager = (SettingManager)context.getBean(SettingManager.class);
            this.versionProperties.put("app.version", settingManager.getValue("system/platform/version"));
            this.versionProperties.put("app.subVersion", settingManager.getValue("system/platform/subVersion"));
            prop.load(input);
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = prop.getProperty(key);
                this.versionProperties.put(key, value);
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork", (String)ex.getMessage(), (Throwable)ex);
        }
    }
}

