/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.cache.FormatterCache;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/formatters"})
@Tag(name="formatters", description="Formatter operations")
@Controller(value="formatters")
@ReadWriteController
public class CacheApi {
    @Operation(summary="Clear formatter cache", description="Formatters are used to render records in various format (HTML, PDF, ...). When a record is rendered a cache is populated for better performance. By default the cache is an H2 database with files on the filesystems (See <dataDirectory>/resources/htmlcache/formatter-cache folder).")
    @RequestMapping(value={"/cache"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Cache cleared.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrator can access it.")})
    public void clearFormatterCache() throws Exception {
        FormatterCache formatterCache = (FormatterCache)ApplicationContextHolder.get().getBean(FormatterCache.class);
        formatterCache.clear();
    }
}

