/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.identifiers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.MetadataIdentifierTemplate;
import org.fao.geonet.repository.MetadataIdentifierTemplateRepository;
import org.fao.geonet.repository.specification.MetadataIdentifierTemplateSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/identifiers"})
@Tag(name="identifiers", description="Identifiers operations")
@Controller(value="identifiers")
@PreAuthorize(value="hasAuthority('Editor')")
public class IdentifiersApi {
    public static final String MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID = "No metadata identifier found with id '%d'.";
    private static final String API_PARAM_IDENTIFIER = "Identifier template identifier";
    private static final String API_PARAM_IDENTIFIER_TEMPLATE_DETAILS = "Identifier template details";
    @Autowired
    private MetadataIdentifierTemplateRepository metadataIdentifierTemplateRepository;

    @Operation(summary="Get identifier templates", description="Identifier templates are used to create record UUIDs having a particular structure. The template will be used when user creates a new record. The identifier template to use is defined in the admin console > metadata and templates.")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of identifier templates."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasAuthority('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public List<MetadataIdentifierTemplate> getIdentifiers(@Parameter(description="Only user defined ones", required=false) @RequestParam(required=false, defaultValue="false") boolean userDefinedOnly) throws Exception {
        if (userDefinedOnly) {
            return this.metadataIdentifierTemplateRepository.findAll(MetadataIdentifierTemplateSpecs.isSystemProvided((boolean)false));
        }
        return this.metadataIdentifierTemplateRepository.findAll();
    }

    @Operation(summary="Add an identifier template", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Identifier template created."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasAuthority('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public ResponseEntity<Integer> addIdentifier(@Parameter(description="Identifier template details") @RequestBody MetadataIdentifierTemplate metadataIdentifierTemplate) throws Exception {
        Optional existingId = this.metadataIdentifierTemplateRepository.findById((Object)metadataIdentifierTemplate.getId());
        if (existingId.isPresent()) {
            throw new IllegalArgumentException(String.format("A metadata identifier template with id '%d' already exist.", metadataIdentifierTemplate.getId()));
        }
        metadataIdentifierTemplate = (MetadataIdentifierTemplate)this.metadataIdentifierTemplateRepository.save((Object)metadataIdentifierTemplate);
        return new ResponseEntity((Object)metadataIdentifierTemplate.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Update an identifier template", description="")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Identifier template updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasAuthority('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void updateIdentifier(@Parameter(description="Identifier template identifier") @PathVariable Integer identifier, @Parameter(description="Identifier template details") @RequestBody MetadataIdentifierTemplate metadataIdentifierTemplate) throws Exception {
        Optional existing = this.metadataIdentifierTemplateRepository.findById((Object)identifier);
        if (!existing.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID, identifier));
        }
        this.metadataIdentifierTemplateRepository.save((Object)metadataIdentifierTemplate);
    }

    @Operation(summary="Remove an identifier template", description="")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Template identifier removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasAuthority('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void deleteIdentifier(@Parameter(description="Identifier template identifier", required=true) @PathVariable int identifier) throws Exception {
        Optional existing = this.metadataIdentifierTemplateRepository.findById((Object)identifier);
        if (!existing.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID, identifier));
        }
        this.metadataIdentifierTemplateRepository.deleteById((Object)identifier);
    }
}

