/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.sass.RubySassEngine;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.CSS)
public class RubySassCssProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(RubySassCssProcessor.class);
    public static final String ALIAS = "rubySassCss";
    private ObjectPoolHelper<RubySassEngine> enginePool = new ObjectPoolHelper<RubySassEngine>(new ObjectFactory<RubySassEngine>(){

        public RubySassEngine create() {
            return RubySassCssProcessor.this.newEngine();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        RubySassCssProcessor rubySassCssProcessor = this;
        synchronized (rubySassCssProcessor) {
            String content = IOUtils.toString((Reader)reader);
            RubySassEngine engine = this.enginePool.getObject();
            try (Reader reader2 = reader;
                 Writer writer2 = writer;){
                writer.write(engine.process(content));
            }
            catch (WroRuntimeException e) {
                this.onException(e);
                String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
                LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            }
            finally {
                this.enginePool.returnObject(engine);
            }
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected RubySassEngine newEngine() {
        return new RubySassEngine();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

