/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.Parser;

public class EndRequestContentParser
extends ContentParser {
    private final Parser.Listener listener;
    private State state = State.APPLICATION;
    private int cursor;
    private int application;
    private int protocol;

    public EndRequestContentParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser);
        this.listener = listener;
    }

    @Override
    public ContentParser.Result parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state) {
                case APPLICATION: {
                    if (buffer.remaining() >= 4) {
                        this.application = buffer.getInt();
                        this.state = State.PROTOCOL;
                        continue block7;
                    }
                    this.state = State.APPLICATION_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case APPLICATION_BYTES: {
                    int quarterInt = buffer.get() & 0xFF;
                    this.application = (this.application << 8) + quarterInt;
                    if (++this.cursor != 4) continue block7;
                    this.state = State.PROTOCOL;
                    continue block7;
                }
                case PROTOCOL: {
                    this.protocol = buffer.get() & 0xFF;
                    this.state = State.RESERVED;
                    continue block7;
                }
                case RESERVED: {
                    if (buffer.remaining() >= 3) {
                        buffer.position(buffer.position() + 3);
                        this.onEnd();
                        this.reset();
                        return ContentParser.Result.COMPLETE;
                    }
                    this.state = State.RESERVED_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case RESERVED_BYTES: {
                    buffer.get();
                    if (++this.cursor != 3) continue block7;
                    this.onEnd();
                    this.reset();
                    return ContentParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return ContentParser.Result.PENDING;
    }

    private void onEnd() {
        if (this.application != 0) {
            this.listener.onFailure(this.getRequest(), new Exception("FastCGI application returned code " + this.application));
        } else if (this.protocol != 0) {
            this.listener.onFailure(this.getRequest(), new Exception("FastCGI server returned code " + this.protocol));
        } else {
            this.listener.onEnd(this.getRequest());
        }
    }

    private void reset() {
        this.state = State.APPLICATION;
        this.cursor = 0;
        this.application = 0;
        this.protocol = 0;
    }

    private static enum State {
        APPLICATION,
        APPLICATION_BYTES,
        PROTOCOL,
        RESERVED,
        RESERVED_BYTES;

    }
}

