/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JwtConfiguration
implements Serializable {
    protected UserNameHeaderFormat userNameFormatChoice;
    protected String userNameJsonPath;
    protected String rolesHeaderName;
    protected String rolesJsonPath;
    protected String roleConverterString;
    protected boolean onlyExternalListedRoles;
    protected boolean validateToken;
    protected boolean validateTokenExpiry;
    protected boolean validateTokenSignature;
    protected String validateTokenSignatureURL;
    protected boolean validateTokenAgainstURL;
    protected String validateTokenAgainstURLEndpoint;
    protected boolean validateSubjectWithEndpoint;
    protected boolean validateTokenAudience;
    protected String validateTokenAudienceClaimName;
    protected String validateTokenAudienceClaimValue;
    protected String userNameHeaderAttributeName;
    protected String JwtHeaderRoleSource;

    public Map<String, List<String>> getRoleConverterAsMap() {
        String[] parts;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (this.roleConverterString == null || this.roleConverterString.isBlank()) {
            return result;
        }
        for (String part : parts = this.roleConverterString.split(";")) {
            String[] keyValue = part.split("=");
            if (keyValue.length != 2) continue;
            String key = this.goodCharacters(keyValue[0]);
            String val = this.goodCharacters(keyValue[1]);
            if (key.isBlank() || val.isBlank()) continue;
            if (!result.containsKey(key)) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(val);
                result.put(key, list);
                continue;
            }
            ((List)result.get(key)).add(val);
        }
        return result;
    }

    public String goodCharacters(String str) {
        return str.replaceAll("[^a-zA-Z0-9_\\-\\.]", "");
    }

    public UserNameHeaderFormat getUserNameFormatChoice() {
        return this.userNameFormatChoice;
    }

    public void setUserNameFormatChoice(UserNameHeaderFormat userNameFormatChoice) {
        this.userNameFormatChoice = userNameFormatChoice;
    }

    public String getUserNameJsonPath() {
        return this.userNameJsonPath;
    }

    public void setUserNameJsonPath(String userNameJsonPath) {
        this.userNameJsonPath = userNameJsonPath;
    }

    public String getRolesHeaderName() {
        return this.rolesHeaderName;
    }

    public void setRolesHeaderName(String rolesHeaderName) {
        this.rolesHeaderName = rolesHeaderName;
    }

    public String getRolesJsonPath() {
        return this.rolesJsonPath;
    }

    public void setRolesJsonPath(String rolesJsonPath) {
        this.rolesJsonPath = rolesJsonPath;
    }

    public String getRoleConverterString() {
        return this.roleConverterString;
    }

    public void setRoleConverterString(String roleConverterString) {
        this.roleConverterString = roleConverterString;
    }

    public boolean isOnlyExternalListedRoles() {
        return this.onlyExternalListedRoles;
    }

    public void setOnlyExternalListedRoles(boolean onlyExternalListedRoles) {
        this.onlyExternalListedRoles = onlyExternalListedRoles;
    }

    public boolean isValidateToken() {
        return this.validateToken;
    }

    public void setValidateToken(boolean validateToken) {
        this.validateToken = validateToken;
    }

    public boolean isValidateTokenExpiry() {
        return this.validateTokenExpiry;
    }

    public void setValidateTokenExpiry(boolean validateTokenExpiry) {
        this.validateTokenExpiry = validateTokenExpiry;
    }

    public boolean isValidateTokenSignature() {
        return this.validateTokenSignature;
    }

    public void setValidateTokenSignature(boolean validateTokenSignature) {
        this.validateTokenSignature = validateTokenSignature;
    }

    public String getValidateTokenSignatureURL() {
        return this.validateTokenSignatureURL;
    }

    public void setValidateTokenSignatureURL(String validateTokenSignatureURL) {
        this.validateTokenSignatureURL = validateTokenSignatureURL;
    }

    public boolean isValidateTokenAgainstURL() {
        return this.validateTokenAgainstURL;
    }

    public void setValidateTokenAgainstURL(boolean validateTokenAgainstURL) {
        this.validateTokenAgainstURL = validateTokenAgainstURL;
    }

    public String getValidateTokenAgainstURLEndpoint() {
        return this.validateTokenAgainstURLEndpoint;
    }

    public void setValidateTokenAgainstURLEndpoint(String validateTokenAgainstURLEndpoint) {
        this.validateTokenAgainstURLEndpoint = validateTokenAgainstURLEndpoint;
    }

    public boolean isValidateSubjectWithEndpoint() {
        return this.validateSubjectWithEndpoint;
    }

    public void setValidateSubjectWithEndpoint(boolean validateSubjectWithEndpoint) {
        this.validateSubjectWithEndpoint = validateSubjectWithEndpoint;
    }

    public boolean isValidateTokenAudience() {
        return this.validateTokenAudience;
    }

    public void setValidateTokenAudience(boolean validateTokenAudience) {
        this.validateTokenAudience = validateTokenAudience;
    }

    public String getValidateTokenAudienceClaimName() {
        return this.validateTokenAudienceClaimName;
    }

    public void setValidateTokenAudienceClaimName(String validateTokenAudienceClaimName) {
        this.validateTokenAudienceClaimName = validateTokenAudienceClaimName;
    }

    public String getValidateTokenAudienceClaimValue() {
        return this.validateTokenAudienceClaimValue;
    }

    public void setValidateTokenAudienceClaimValue(String validateTokenAudienceClaimValue) {
        this.validateTokenAudienceClaimValue = validateTokenAudienceClaimValue;
    }

    public String getUserNameHeaderAttributeName() {
        return this.userNameHeaderAttributeName;
    }

    public void setUserNameHeaderAttributeName(String userNameHeaderAttributeName) {
        this.userNameHeaderAttributeName = userNameHeaderAttributeName;
    }

    public String getJwtHeaderRoleSource() {
        return this.JwtHeaderRoleSource;
    }

    public void setJwtHeaderRoleSource(String jwtHeaderRoleSource) {
        this.JwtHeaderRoleSource = jwtHeaderRoleSource;
    }

    public static enum JWTHeaderRoleSource {
        JSON,
        JWT;

    }

    public static enum UserNameHeaderFormat {
        STRING,
        JSON,
        JWT;

    }
}

