/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.ObjectEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.xml.sax.helpers.AttributesImpl;

class EnvelopeEncoder
extends ObjectEncoder<Envelope> {
    static final QualifiedName BOX = new QualifiedName("http://www.opengis.net/gml", "Box", "gml");
    QualifiedName box;

    protected EnvelopeEncoder(Encoder e, String gmlNamespace) {
        super(e);
        this.box = BOX.derive(gmlNamespace);
    }

    @Override
    public void encode(Envelope e, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.box, atts);
        handler.coordinates((CoordinateSequence)new LiteCoordinateSequence(new double[]{e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY()}));
        handler.endElement(this.box);
    }
}

