/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IncrementOrder implements Enumerator
{
    XY(0, "xY", "+x+y"),
    YX(1, "yX", "+y+x"),
    XY1(2, "xY1", "+x-y"),
    XY2(3, "xY2", "-x-y");

    public static final int XY_VALUE = 0;
    public static final int YX_VALUE = 1;
    public static final int XY1_VALUE = 2;
    public static final int XY2_VALUE = 3;
    private static final IncrementOrder[] VALUES_ARRAY;
    public static final List<IncrementOrder> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static IncrementOrder get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IncrementOrder result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static IncrementOrder getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IncrementOrder result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static IncrementOrder get(int value) {
        switch (value) {
            case 0: {
                return XY;
            }
            case 1: {
                return YX;
            }
            case 2: {
                return XY1;
            }
            case 3: {
                return XY2;
            }
        }
        return null;
    }

    private IncrementOrder(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new IncrementOrder[]{XY, YX, XY1, XY2};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

