/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input;

import it.geosolutions.imageio.stream.AccessibleStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageInputStreamAdapter
extends ImageInputStreamImpl
implements AccessibleStream<InputStream> {
    private InputStream is;

    public ImageInputStreamAdapter(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("is == null!");
        }
        this.is = stream;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.is.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        this.bitOffset = 0;
        if (len == 0) {
            return 0;
        }
        int val = this.is.read(b, off, len);
        if (val != -1) {
            ++this.streamPos;
        }
        this.streamPos += (long)len;
        return val;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.is.close();
    }

    @Override
    public void mark() {
        if (!this.is.markSupported()) {
            throw new UnsupportedOperationException("Mark is not supported by underlying is");
        }
        this.is.mark(Integer.MAX_VALUE);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    public static final ImageInputStream getStream(InputStream stream) {
        if (stream.markSupported() && !(stream instanceof InflaterInputStream)) {
            return new ImageInputStreamAdapter(stream);
        }
        if (ImageIO.getUseCache()) {
            try {
                return new FileCacheImageInputStream(stream, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new MemoryCacheImageInputStream(stream);
    }

    @Override
    public InputStream getTarget() {
        return this.is;
    }

    @Override
    public Class<InputStream> getBinding() {
        return InputStream.class;
    }
}

